###############################################################################
# OpenVAS Vulnerability Test
#
# Ubuntu Update for postgresql-8.1, postgresql-8.2 vulnerability USN-454-1
#
# Authors:
# System Generated Check
#
# Copyright:
# Copyright (c) 2009 Intevation GmbH, http://www.intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(840046);
  script_version("$Revision: 1.0 $");
  script_xref(name: "USN", value: "454-1");
  script_cve_id("CVE-2007-2138");
  script_name( "Ubuntu Update for postgresql-8.1, postgresql-8.2 vulnerability USN-454-1");
  desc = "

  Vulnerability Insight:

  PostgreSQL did not handle the &quot;search_path&quot; configuration option in a
  secure way for functions declared as &quot;SECURITY DEFINER&quot;.
  
  Previously, an attacker could override functions and operators used by
  the security definer function to execute arbitrary SQL commands with
  the privileges of the user who created the security definer function.
  The updated version does not search the temporary table schema for
  functions and operators any more.
  
  Similarly, an attacker could put forged tables into the temporary
  table schema to trick the security definer function into using
  attacker defined data for processing. This was possible because the
  temporary schema was always implicitly searched first before all other
  entries in &quot;search_path&quot;. The updated version now supports explicit
  placement of the temporary schema. Please see the HTML documentation
  or the manual page for &quot;CREATE FUNCTION&quot; for details and an example
  how to write security definer functions in a secure way.

  Affected Software/OS:
  postgresql-8.1, postgresql-8.2 vulnerability on Ubuntu 6.06 LTS ,
  Ubuntu 6.10 ,
  Ubuntu 7.04

  Fix: Please Install the Updated Packages.

  References:
  https://lists.ubuntu.com/archives/ubuntu-security-announce/2007-April/000524.html

  Risk factor: High";

  script_description(desc);
  script_summary("Check for the Version of postgresql-8.1, postgresql-8.2 vulnerability");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (C) 2009 Intevation GmbH");
  script_family("Ubuntu Local Security Checks");
  script_dependencies("gather-package-list.nasl");
  script_require_keys("ssh/login/release");
  exit(0);
}


include("pkg-lib-deb.inc");
include("revisions-lib.inc");

release = get_kb_item("ssh/login/release");

if(release == NULL){
  exit(0);
}

if(release == "UBUNTU7.04")
{

  if(isdpkgvuln(pkg:"libecpg-compat2", ver:"8.2.4-0ubuntu0.7.04", rls:"UBUNTU7.04"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"libecpg-dev", ver:"8.2.4-0ubuntu0.7.04", rls:"UBUNTU7.04"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"libecpg5", ver:"8.2.4-0ubuntu0.7.04", rls:"UBUNTU7.04"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"libpgtypes2", ver:"8.2.4-0ubuntu0.7.04", rls:"UBUNTU7.04"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"libpq-dev", ver:"8.2.4-0ubuntu0.7.04", rls:"UBUNTU7.04"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"libpq5", ver:"8.2.4-0ubuntu0.7.04", rls:"UBUNTU7.04"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"postgresql", ver:"8.2_8.2.4-0ubuntu0.7.04", rls:"UBUNTU7.04"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"postgresql-client", ver:"8.2_8.2.4-0ubuntu0.7.04", rls:"UBUNTU7.04"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"postgresql-contrib", ver:"8.2_8.2.4-0ubuntu0.7.04", rls:"UBUNTU7.04"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"postgresql-plperl", ver:"8.2_8.2.4-0ubuntu0.7.04", rls:"UBUNTU7.04"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"postgresql-plpython", ver:"8.2_8.2.4-0ubuntu0.7.04", rls:"UBUNTU7.04"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"postgresql-pltcl", ver:"8.2_8.2.4-0ubuntu0.7.04", rls:"UBUNTU7.04"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"postgresql-server-dev", ver:"8.2_8.2.4-0ubuntu0.7.04", rls:"UBUNTU7.04"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"postgresql-doc", ver:"8.2_8.2.4-0ubuntu0.7.04", rls:"UBUNTU7.04"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}


if(release == "UBUNTU6.06 LTS")
{

  if(isdpkgvuln(pkg:"libecpg-compat2", ver:"8.1.9-0ubuntu0.6.06", rls:"UBUNTU6.06 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"libecpg-dev", ver:"8.1.9-0ubuntu0.6.06", rls:"UBUNTU6.06 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"libecpg5", ver:"8.1.9-0ubuntu0.6.06", rls:"UBUNTU6.06 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"libpgtypes2", ver:"8.1.9-0ubuntu0.6.06", rls:"UBUNTU6.06 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"libpq-dev", ver:"8.1.9-0ubuntu0.6.06", rls:"UBUNTU6.06 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"libpq4", ver:"8.1.9-0ubuntu0.6.06", rls:"UBUNTU6.06 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"postgresql", ver:"8.1_8.1.9-0ubuntu0.6.06", rls:"UBUNTU6.06 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"postgresql-client", ver:"8.1_8.1.9-0ubuntu0.6.06", rls:"UBUNTU6.06 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"postgresql-contrib", ver:"8.1_8.1.9-0ubuntu0.6.06", rls:"UBUNTU6.06 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"postgresql-plperl", ver:"8.1_8.1.9-0ubuntu0.6.06", rls:"UBUNTU6.06 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"postgresql-plpython", ver:"8.1_8.1.9-0ubuntu0.6.06", rls:"UBUNTU6.06 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"postgresql-pltcl", ver:"8.1_8.1.9-0ubuntu0.6.06", rls:"UBUNTU6.06 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"postgresql-server-dev", ver:"8.1_8.1.9-0ubuntu0.6.06", rls:"UBUNTU6.06 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"postgresql-doc", ver:"8.1_8.1.9-0ubuntu0.6.06", rls:"UBUNTU6.06 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}


if(release == "UBUNTU6.10")
{

  if(isdpkgvuln(pkg:"libecpg-compat2", ver:"8.1.9-0ubuntu0.6.10", rls:"UBUNTU6.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"libecpg-dev", ver:"8.1.9-0ubuntu0.6.10", rls:"UBUNTU6.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"libecpg5", ver:"8.1.9-0ubuntu0.6.10", rls:"UBUNTU6.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"libpgtypes2", ver:"8.1.9-0ubuntu0.6.10", rls:"UBUNTU6.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"libpq-dev", ver:"8.1.9-0ubuntu0.6.10", rls:"UBUNTU6.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"libpq4", ver:"8.1.9-0ubuntu0.6.10", rls:"UBUNTU6.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"postgresql", ver:"8.1_8.1.9-0ubuntu0.6.10", rls:"UBUNTU6.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"postgresql-client", ver:"8.1_8.1.9-0ubuntu0.6.10", rls:"UBUNTU6.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"postgresql-contrib", ver:"8.1_8.1.9-0ubuntu0.6.10", rls:"UBUNTU6.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"postgresql-plperl", ver:"8.1_8.1.9-0ubuntu0.6.10", rls:"UBUNTU6.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"postgresql-plpython", ver:"8.1_8.1.9-0ubuntu0.6.10", rls:"UBUNTU6.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"postgresql-pltcl", ver:"8.1_8.1.9-0ubuntu0.6.10", rls:"UBUNTU6.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"postgresql-server-dev", ver:"8.1_8.1.9-0ubuntu0.6.10", rls:"UBUNTU6.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"postgresql-doc", ver:"8.1_8.1.9-0ubuntu0.6.10", rls:"UBUNTU6.10"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}