###############################################################################
# OpenVAS Vulnerability Test
#
# Ubuntu Update for libgd2 vulnerabilities USN-473-1
#
# Authors:
# System Generated Check
#
# Copyright:
# Copyright (c) 2009 Intevation GmbH, http://www.intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(840026);
  script_version("$Revision: 1.0 $");
  script_xref(name: "USN", value: "473-1");
  script_cve_id("CVE-2007-0455", "CVE-2007-2756");
  script_name( "Ubuntu Update for libgd2 vulnerabilities USN-473-1");
  desc = "

  Vulnerability Insight:

  A buffer overflow was discovered in libgd2's font renderer.  By tricking
  an application using libgd2 into rendering a specially crafted string
  with a JIS encoded font, a remote attacker could read heap memory or
  crash the application, leading to a denial of service. (CVE-2007-0455)
  
  Xavier Roche discovered that libgd2 did not correctly validate PNG
  callback results.  If an application were tricked into processing a
  specially crafted PNG image, it would monopolize CPU resources.  Since
  libgd2 is often used in PHP and Perl web applications, this could lead
  to a remote denial of service. (CVE-2007-2756)

  Affected Software/OS:
  libgd2 vulnerabilities on Ubuntu 6.06 LTS ,
  Ubuntu 6.10 ,
  Ubuntu 7.04

  Fix: Please Install the Updated Packages.

  References:
  https://lists.ubuntu.com/archives/ubuntu-security-announce/2007-June/000546.html

  Risk factor: High";

  script_description(desc);
  script_summary("Check for the Version of libgd2 vulnerabilities");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (C) 2009 Intevation GmbH");
  script_family("Ubuntu Local Security Checks");
  script_dependencies("gather-package-list.nasl");
  script_require_keys("ssh/login/release");
  exit(0);
}


include("pkg-lib-deb.inc");
include("revisions-lib.inc");

release = get_kb_item("ssh/login/release");

if(release == NULL){
  exit(0);
}

if(release == "UBUNTU7.04")
{

  if(isdpkgvuln(pkg:"libgd-tools", ver:"2.0.34~rc1-2ubuntu1.1", rls:"UBUNTU7.04"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"libgd2-noxpm-dev", ver:"2.0.34~rc1-2ubuntu1.1", rls:"UBUNTU7.04"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"libgd2-noxpm", ver:"2.0.34~rc1-2ubuntu1.1", rls:"UBUNTU7.04"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"libgd2-xpm-dev", ver:"2.0.34~rc1-2ubuntu1.1", rls:"UBUNTU7.04"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"libgd2-xpm", ver:"2.0.34~rc1-2ubuntu1.1", rls:"UBUNTU7.04"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}


if(release == "UBUNTU6.06 LTS")
{

  if(isdpkgvuln(pkg:"libgd-tools", ver:"2.0.33-2ubuntu5.2", rls:"UBUNTU6.06 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"libgd2-noxpm-dev", ver:"2.0.33-2ubuntu5.2", rls:"UBUNTU6.06 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"libgd2-noxpm", ver:"2.0.33-2ubuntu5.2", rls:"UBUNTU6.06 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"libgd2-xpm-dev", ver:"2.0.33-2ubuntu5.2", rls:"UBUNTU6.06 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"libgd2-xpm", ver:"2.0.33-2ubuntu5.2", rls:"UBUNTU6.06 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"libgd2-dev", ver:"2.0.33-2ubuntu5.2", rls:"UBUNTU6.06 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"libgd2", ver:"2.0.33-2ubuntu5.2", rls:"UBUNTU6.06 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}


if(release == "UBUNTU6.10")
{

  if(isdpkgvuln(pkg:"libgd-tools", ver:"2.0.33-4ubuntu2.1", rls:"UBUNTU6.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"libgd2-noxpm-dev", ver:"2.0.33-4ubuntu2.1", rls:"UBUNTU6.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"libgd2-noxpm", ver:"2.0.33-4ubuntu2.1", rls:"UBUNTU6.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"libgd2-xpm-dev", ver:"2.0.33-4ubuntu2.1", rls:"UBUNTU6.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"libgd2-xpm", ver:"2.0.33-4ubuntu2.1", rls:"UBUNTU6.10"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}