###############################################################################
# OpenVAS Vulnerability Test
#
# Ubuntu Update for libvorbis vulnerabilities USN-498-1
#
# Authors:
# System Generated Check
#
# Copyright:
# Copyright (c) 2009 Intevation GmbH, http://www.intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(840176);
  script_version("$Revision: 1.0 $");
  script_xref(name: "USN", value: "498-1");
  script_cve_id("CVE-2007-3106", "CVE-2007-4029");
  script_name( "Ubuntu Update for libvorbis vulnerabilities USN-498-1");
  desc = "

  Vulnerability Insight:

  David Thiel discovered that libvorbis did not correctly verify the size
  of certain headers, and did not correctly clean up a broken stream.
  If a user were tricked into processing a specially crafted Vorbis stream,
  a remote attacker could execute arbitrary code with the user's privileges.

  Affected Software/OS:
  libvorbis vulnerabilities on Ubuntu 6.06 LTS ,
  Ubuntu 6.10 ,
  Ubuntu 7.04

  Fix: Please Install the Updated Packages.

  References:
  https://lists.ubuntu.com/archives/ubuntu-security-announce/2007-August/000573.html

  Risk factor: High";

  script_description(desc);
  script_summary("Check for the Version of libvorbis vulnerabilities");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (C) 2009 Intevation GmbH");
  script_family("Ubuntu Local Security Checks");
  script_dependencies("gather-package-list.nasl");
  script_require_keys("ssh/login/release");
  exit(0);
}


include("pkg-lib-deb.inc");
include("revisions-lib.inc");

release = get_kb_item("ssh/login/release");

if(release == NULL){
  exit(0);
}

if(release == "UBUNTU7.04")
{

  if(isdpkgvuln(pkg:"libvorbis-dev", ver:"1.1.2.dfsg-1.2ubuntu2", rls:"UBUNTU7.04"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"libvorbis0a", ver:"1.1.2.dfsg-1.2ubuntu2", rls:"UBUNTU7.04"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"libvorbisenc2", ver:"1.1.2.dfsg-1.2ubuntu2", rls:"UBUNTU7.04"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"libvorbisfile3", ver:"1.1.2.dfsg-1.2ubuntu2", rls:"UBUNTU7.04"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}


if(release == "UBUNTU6.06 LTS")
{

  if(isdpkgvuln(pkg:"libvorbis-dev", ver:"1.1.2-0ubuntu2.2", rls:"UBUNTU6.06 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"libvorbis0a", ver:"1.1.2-0ubuntu2.2", rls:"UBUNTU6.06 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"libvorbisenc2", ver:"1.1.2-0ubuntu2.2", rls:"UBUNTU6.06 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"libvorbisfile3", ver:"1.1.2-0ubuntu2.2", rls:"UBUNTU6.06 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}


if(release == "UBUNTU6.10")
{

  if(isdpkgvuln(pkg:"libvorbis-dev", ver:"1.1.2-1ubuntu1.2", rls:"UBUNTU6.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"libvorbis0a", ver:"1.1.2-1ubuntu1.2", rls:"UBUNTU6.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"libvorbisenc2", ver:"1.1.2-1ubuntu1.2", rls:"UBUNTU6.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"libvorbisfile3", ver:"1.1.2-1ubuntu1.2", rls:"UBUNTU6.10"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}