###############################################################################
# OpenVAS Vulnerability Test
#
# Ubuntu Update for mono vulnerability USN-553-1
#
# Authors:
# System Generated Check
#
# Copyright:
# Copyright (c) 2009 Intevation GmbH, http://www.intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(840005);
  script_version("$Revision: 1.0 $");
  script_xref(name: "USN", value: "553-1");
  script_cve_id("CVE-2007-5197");
  script_name( "Ubuntu Update for mono vulnerability USN-553-1");
  desc = "

  Vulnerability Insight:

  It was discovered that Mono did not correctly bounds check certain BigInteger
  actions.  Remote attackers could exploit this to crash a Mono application or
  possibly execute arbitrary code with user privileges.

  Affected Software/OS:
  mono vulnerability on Ubuntu 6.06 LTS ,
  Ubuntu 6.10 ,
  Ubuntu 7.04 ,
  Ubuntu 7.10

  Fix: Please Install the Updated Packages.

  References:
  https://lists.ubuntu.com/archives/ubuntu-security-announce/2007-December/000637.html

  Risk factor: High";

  script_description(desc);
  script_summary("Check for the Version of mono vulnerability");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (C) 2009 Intevation GmbH");
  script_family("Ubuntu Local Security Checks");
  script_dependencies("gather-package-list.nasl");
  script_require_keys("ssh/login/release");
  exit(0);
}


include("pkg-lib-deb.inc");
include("revisions-lib.inc");

release = get_kb_item("ssh/login/release");

if(release == NULL){
  exit(0);
}

if(release == "UBUNTU7.04")
{

  if(isdpkgvuln(pkg:"libmono-dev", ver:"1.2.3.1-1ubuntu1.1", rls:"UBUNTU7.04"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"libmono0", ver:"1.2.3.1-1ubuntu1.1", rls:"UBUNTU7.04"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"mono-common", ver:"1.2.3.1-1ubuntu1.1", rls:"UBUNTU7.04"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"mono-devel", ver:"1.2.3.1-1ubuntu1.1", rls:"UBUNTU7.04"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"mono-jay", ver:"1.2.3.1-1ubuntu1.1", rls:"UBUNTU7.04"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"mono-jit", ver:"1.2.3.1-1ubuntu1.1", rls:"UBUNTU7.04"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"mono-runtime", ver:"1.2.3.1-1ubuntu1.1", rls:"UBUNTU7.04"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"mono-utils", ver:"1.2.3.1-1ubuntu1.1", rls:"UBUNTU7.04"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"mono", ver:"1.2.3.1-1ubuntu1.1", rls:"UBUNTU7.04"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"libmono-accessibility1.0-cil", ver:"1.2.3.1-1ubuntu1.1", rls:"UBUNTU7.04"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"libmono-accessibility2.0-cil", ver:"1.2.3.1-1ubuntu1.1", rls:"UBUNTU7.04"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"libmono-cairo1.0-cil", ver:"1.2.3.1-1ubuntu1.1", rls:"UBUNTU7.04"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"libmono-cairo2.0-cil", ver:"1.2.3.1-1ubuntu1.1", rls:"UBUNTU7.04"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"libmono-corlib1.0-cil", ver:"1.2.3.1-1ubuntu1.1", rls:"UBUNTU7.04"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"libmono-corlib2.0-cil", ver:"1.2.3.1-1ubuntu1.1", rls:"UBUNTU7.04"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"libmono-data-tds1.0-cil", ver:"1.2.3.1-1ubuntu1.1", rls:"UBUNTU7.04"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"libmono-data-tds2.0-cil", ver:"1.2.3.1-1ubuntu1.1", rls:"UBUNTU7.04"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"libmono-microsoft-build2.0-cil", ver:"1.2.3.1-1ubuntu1.1", rls:"UBUNTU7.04"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"libmono-peapi1.0-cil", ver:"1.2.3.1-1ubuntu1.1", rls:"UBUNTU7.04"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"libmono-peapi2.0-cil", ver:"1.2.3.1-1ubuntu1.1", rls:"UBUNTU7.04"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"libmono-relaxng1.0-cil", ver:"1.2.3.1-1ubuntu1.1", rls:"UBUNTU7.04"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"libmono-security1.0-cil", ver:"1.2.3.1-1ubuntu1.1", rls:"UBUNTU7.04"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"libmono-security2.0-cil", ver:"1.2.3.1-1ubuntu1.1", rls:"UBUNTU7.04"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"libmono-sharpzip0.6-cil", ver:"1.2.3.1-1ubuntu1.1", rls:"UBUNTU7.04"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"libmono-sharpzip0.84-cil", ver:"1.2.3.1-1ubuntu1.1", rls:"UBUNTU7.04"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"libmono-sharpzip2.84-cil", ver:"1.2.3.1-1ubuntu1.1", rls:"UBUNTU7.04"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"libmono-sqlite1.0-cil", ver:"1.2.3.1-1ubuntu1.1", rls:"UBUNTU7.04"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"libmono-sqlite2.0-cil", ver:"1.2.3.1-1ubuntu1.1", rls:"UBUNTU7.04"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"libmono-system-data1.0-cil", ver:"1.2.3.1-1ubuntu1.1", rls:"UBUNTU7.04"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"libmono-system-data2.0-cil", ver:"1.2.3.1-1ubuntu1.1", rls:"UBUNTU7.04"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"libmono-system-runtime1.0-cil", ver:"1.2.3.1-1ubuntu1.1", rls:"UBUNTU7.04"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"libmono-system-runtime2.0-cil", ver:"1.2.3.1-1ubuntu1.1", rls:"UBUNTU7.04"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"libmono-system-web1.0-cil", ver:"1.2.3.1-1ubuntu1.1", rls:"UBUNTU7.04"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"libmono-system-web2.0-cil", ver:"1.2.3.1-1ubuntu1.1", rls:"UBUNTU7.04"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"libmono-system1.0-cil", ver:"1.2.3.1-1ubuntu1.1", rls:"UBUNTU7.04"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"libmono-system2.0-cil", ver:"1.2.3.1-1ubuntu1.1", rls:"UBUNTU7.04"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"libmono-winforms1.0-cil", ver:"1.2.3.1-1ubuntu1.1", rls:"UBUNTU7.04"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"libmono-winforms2.0-cil", ver:"1.2.3.1-1ubuntu1.1", rls:"UBUNTU7.04"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"libmono1.0-cil", ver:"1.2.3.1-1ubuntu1.1", rls:"UBUNTU7.04"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"libmono2.0-cil", ver:"1.2.3.1-1ubuntu1.1", rls:"UBUNTU7.04"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"mono-gac", ver:"1.2.3.1-1ubuntu1.1", rls:"UBUNTU7.04"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"mono-gmcs", ver:"1.2.3.1-1ubuntu1.1", rls:"UBUNTU7.04"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"mono-mcs", ver:"1.2.3.1-1ubuntu1.1", rls:"UBUNTU7.04"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"libmono-bytefx0.7.6.1-cil", ver:"1.2.3.1-1ubuntu1.1", rls:"UBUNTU7.04"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"libmono-bytefx0.7.6.2-cil", ver:"1.2.3.1-1ubuntu1.1", rls:"UBUNTU7.04"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"libmono-c5", ver:"1.0-cil_1.2.3.1-1ubuntu1.1", rls:"UBUNTU7.04"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"libmono-cscompmgd7.0-cil", ver:"1.2.3.1-1ubuntu1.1", rls:"UBUNTU7.04"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"libmono-cscompmgd8.0-cil", ver:"1.2.3.1-1ubuntu1.1", rls:"UBUNTU7.04"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"libmono-firebirdsql1.7-cil", ver:"1.2.3.1-1ubuntu1.1", rls:"UBUNTU7.04"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"libmono-ldap1.0-cil", ver:"1.2.3.1-1ubuntu1.1", rls:"UBUNTU7.04"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"libmono-ldap2.0-cil", ver:"1.2.3.1-1ubuntu1.1", rls:"UBUNTU7.04"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"libmono-microsoft7.0-cil", ver:"1.2.3.1-1ubuntu1.1", rls:"UBUNTU7.04"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"libmono-microsoft8.0-cil", ver:"1.2.3.1-1ubuntu1.1", rls:"UBUNTU7.04"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"libmono-npgsql1.0-cil", ver:"1.2.3.1-1ubuntu1.1", rls:"UBUNTU7.04"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"libmono-npgsql2.0-cil", ver:"1.2.3.1-1ubuntu1.1", rls:"UBUNTU7.04"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"libmono-oracle1.0-cil", ver:"1.2.3.1-1ubuntu1.1", rls:"UBUNTU7.04"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"libmono-oracle2.0-cil", ver:"1.2.3.1-1ubuntu1.1", rls:"UBUNTU7.04"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"libmono-relaxng2.0-cil", ver:"1.2.3.1-1ubuntu1.1", rls:"UBUNTU7.04"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"libmono-sharpzip2.6-cil", ver:"1.2.3.1-1ubuntu1.1", rls:"UBUNTU7.04"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"libmono-system-ldap1.0-cil", ver:"1.2.3.1-1ubuntu1.1", rls:"UBUNTU7.04"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"libmono-system-ldap2.0-cil", ver:"1.2.3.1-1ubuntu1.1", rls:"UBUNTU7.04"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"libmono-system-messaging1.0-cil", ver:"1.2.3.1-1ubuntu1.1", rls:"UBUNTU7.04"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"libmono-system-messaging2.0-cil", ver:"1.2.3.1-1ubuntu1.1", rls:"UBUNTU7.04"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"mono-mjs", ver:"1.2.3.1-1ubuntu1.1", rls:"UBUNTU7.04"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}


if(release == "UBUNTU6.06 LTS")
{

  if(isdpkgvuln(pkg:"libmono-dev", ver:"1.1.13.6-0ubuntu3.3", rls:"UBUNTU6.06 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"libmono0", ver:"1.1.13.6-0ubuntu3.3", rls:"UBUNTU6.06 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"mono-common", ver:"1.1.13.6-0ubuntu3.3", rls:"UBUNTU6.06 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"mono-devel", ver:"1.1.13.6-0ubuntu3.3", rls:"UBUNTU6.06 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"mono-jay", ver:"1.1.13.6-0ubuntu3.3", rls:"UBUNTU6.06 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"mono-jit", ver:"1.1.13.6-0ubuntu3.3", rls:"UBUNTU6.06 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"mono-utils", ver:"1.1.13.6-0ubuntu3.3", rls:"UBUNTU6.06 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"mono", ver:"1.1.13.6-0ubuntu3.3", rls:"UBUNTU6.06 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"mono-assemblies-base", ver:"1.1.13.6-0ubuntu3.3", rls:"UBUNTU6.06 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"mono-classlib", ver:"1.0-dbg_1.1.13.6-0ubuntu3.3", rls:"UBUNTU6.06 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"mono-classlib", ver:"1.0_1.1.13.6-0ubuntu3.3", rls:"UBUNTU6.06 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"mono-classlib", ver:"2.0_1.1.13.6-0ubuntu3.3", rls:"UBUNTU6.06 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"mono-gac", ver:"1.1.13.6-0ubuntu3.3", rls:"UBUNTU6.06 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"mono-gmcs", ver:"1.1.13.6-0ubuntu3.3", rls:"UBUNTU6.06 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"mono-mcs", ver:"1.1.13.6-0ubuntu3.3", rls:"UBUNTU6.06 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"mono-classlib", ver:"2.0-dbg_1.1.13.6-0ubuntu3.3", rls:"UBUNTU6.06 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}


if(release == "UBUNTU6.10")
{

  if(isdpkgvuln(pkg:"libmono-dev", ver:"1.1.17.1-1ubuntu7.2", rls:"UBUNTU6.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"libmono0", ver:"1.1.17.1-1ubuntu7.2", rls:"UBUNTU6.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"mono-common", ver:"1.1.17.1-1ubuntu7.2", rls:"UBUNTU6.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"mono-devel", ver:"1.1.17.1-1ubuntu7.2", rls:"UBUNTU6.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"mono-jay", ver:"1.1.17.1-1ubuntu7.2", rls:"UBUNTU6.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"mono-jit", ver:"1.1.17.1-1ubuntu7.2", rls:"UBUNTU6.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"mono-runtime", ver:"1.1.17.1-1ubuntu7.2", rls:"UBUNTU6.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"mono-utils", ver:"1.1.17.1-1ubuntu7.2", rls:"UBUNTU6.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"mono", ver:"1.1.17.1-1ubuntu7.2", rls:"UBUNTU6.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"libmono-accessibility1.0-cil", ver:"1.1.17.1-1ubuntu7.2", rls:"UBUNTU6.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"libmono-accessibility2.0-cil", ver:"1.1.17.1-1ubuntu7.2", rls:"UBUNTU6.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"libmono-cairo1.0-cil", ver:"1.1.17.1-1ubuntu7.2", rls:"UBUNTU6.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"libmono-corlib1.0-cil", ver:"1.1.17.1-1ubuntu7.2", rls:"UBUNTU6.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"libmono-corlib2.0-cil", ver:"1.1.17.1-1ubuntu7.2", rls:"UBUNTU6.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"libmono-data-tds1.0-cil", ver:"1.1.17.1-1ubuntu7.2", rls:"UBUNTU6.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"libmono-data-tds2.0-cil", ver:"1.1.17.1-1ubuntu7.2", rls:"UBUNTU6.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"libmono-microsoft-build2.0-cil", ver:"1.1.17.1-1ubuntu7.2", rls:"UBUNTU6.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"libmono-peapi1.0-cil", ver:"1.1.17.1-1ubuntu7.2", rls:"UBUNTU6.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"libmono-peapi2.0-cil", ver:"1.1.17.1-1ubuntu7.2", rls:"UBUNTU6.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"libmono-relaxng1.0-cil", ver:"1.1.17.1-1ubuntu7.2", rls:"UBUNTU6.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"libmono-security1.0-cil", ver:"1.1.17.1-1ubuntu7.2", rls:"UBUNTU6.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"libmono-security2.0-cil", ver:"1.1.17.1-1ubuntu7.2", rls:"UBUNTU6.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"libmono-sharpzip0.6-cil", ver:"1.1.17.1-1ubuntu7.2", rls:"UBUNTU6.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"libmono-sharpzip0.84-cil", ver:"1.1.17.1-1ubuntu7.2", rls:"UBUNTU6.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"libmono-sharpzip2.84-cil", ver:"1.1.17.1-1ubuntu7.2", rls:"UBUNTU6.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"libmono-sqlite1.0-cil", ver:"1.1.17.1-1ubuntu7.2", rls:"UBUNTU6.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"libmono-system-data1.0-cil", ver:"1.1.17.1-1ubuntu7.2", rls:"UBUNTU6.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"libmono-system-data2.0-cil", ver:"1.1.17.1-1ubuntu7.2", rls:"UBUNTU6.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"libmono-system-runtime1.0-cil", ver:"1.1.17.1-1ubuntu7.2", rls:"UBUNTU6.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"libmono-system-web1.0-cil", ver:"1.1.17.1-1ubuntu7.2", rls:"UBUNTU6.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"libmono-system-web2.0-cil", ver:"1.1.17.1-1ubuntu7.2", rls:"UBUNTU6.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"libmono-system1.0-cil", ver:"1.1.17.1-1ubuntu7.2", rls:"UBUNTU6.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"libmono-system2.0-cil", ver:"1.1.17.1-1ubuntu7.2", rls:"UBUNTU6.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"libmono-winforms1.0-cil", ver:"1.1.17.1-1ubuntu7.2", rls:"UBUNTU6.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"libmono-winforms2.0-cil", ver:"1.1.17.1-1ubuntu7.2", rls:"UBUNTU6.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"libmono1.0-cil", ver:"1.1.17.1-1ubuntu7.2", rls:"UBUNTU6.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"libmono2.0-cil", ver:"1.1.17.1-1ubuntu7.2", rls:"UBUNTU6.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"mono-classlib", ver:"1.0_1.1.17.1-1ubuntu7.2", rls:"UBUNTU6.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"mono-gac", ver:"1.1.17.1-1ubuntu7.2", rls:"UBUNTU6.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"mono-gmcs", ver:"1.1.17.1-1ubuntu7.2", rls:"UBUNTU6.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"mono-mcs", ver:"1.1.17.1-1ubuntu7.2", rls:"UBUNTU6.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"libmono-bytefx0.7.6.1-cil", ver:"1.1.17.1-1ubuntu7.2", rls:"UBUNTU6.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"libmono-bytefx0.7.6.2-cil", ver:"1.1.17.1-1ubuntu7.2", rls:"UBUNTU6.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"libmono-c5", ver:"1.0-cil_1.1.17.1-1ubuntu7.2", rls:"UBUNTU6.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"libmono-cairo2.0-cil", ver:"1.1.17.1-1ubuntu7.2", rls:"UBUNTU6.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"libmono-cscompmgd7.0-cil", ver:"1.1.17.1-1ubuntu7.2", rls:"UBUNTU6.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"libmono-cscompmgd8.0-cil", ver:"1.1.17.1-1ubuntu7.2", rls:"UBUNTU6.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"libmono-firebirdsql1.7-cil", ver:"1.1.17.1-1ubuntu7.2", rls:"UBUNTU6.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"libmono-ldap1.0-cil", ver:"1.1.17.1-1ubuntu7.2", rls:"UBUNTU6.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"libmono-ldap2.0-cil", ver:"1.1.17.1-1ubuntu7.2", rls:"UBUNTU6.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"libmono-microsoft7.0-cil", ver:"1.1.17.1-1ubuntu7.2", rls:"UBUNTU6.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"libmono-microsoft8.0-cil", ver:"1.1.17.1-1ubuntu7.2", rls:"UBUNTU6.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"libmono-npgsql1.0-cil", ver:"1.1.17.1-1ubuntu7.2", rls:"UBUNTU6.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"libmono-npgsql2.0-cil", ver:"1.1.17.1-1ubuntu7.2", rls:"UBUNTU6.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"libmono-oracle1.0-cil", ver:"1.1.17.1-1ubuntu7.2", rls:"UBUNTU6.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"libmono-oracle2.0-cil", ver:"1.1.17.1-1ubuntu7.2", rls:"UBUNTU6.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"libmono-relaxng2.0-cil", ver:"1.1.17.1-1ubuntu7.2", rls:"UBUNTU6.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"libmono-sharpzip2.6-cil", ver:"1.1.17.1-1ubuntu7.2", rls:"UBUNTU6.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"libmono-sqlite2.0-cil", ver:"1.1.17.1-1ubuntu7.2", rls:"UBUNTU6.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"libmono-system-ldap1.0-cil", ver:"1.1.17.1-1ubuntu7.2", rls:"UBUNTU6.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"libmono-system-ldap2.0-cil", ver:"1.1.17.1-1ubuntu7.2", rls:"UBUNTU6.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"libmono-system-messaging1.0-cil", ver:"1.1.17.1-1ubuntu7.2", rls:"UBUNTU6.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"libmono-system-messaging2.0-cil", ver:"1.1.17.1-1ubuntu7.2", rls:"UBUNTU6.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"libmono-system-runtime2.0-cil", ver:"1.1.17.1-1ubuntu7.2", rls:"UBUNTU6.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"mono-classlib", ver:"2.0_1.1.17.1-1ubuntu7.2", rls:"UBUNTU6.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"mono-mjs", ver:"1.1.17.1-1ubuntu7.2", rls:"UBUNTU6.10"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}


if(release == "UBUNTU7.10")
{

  if(isdpkgvuln(pkg:"libmono-dev", ver:"1.2.4-6ubuntu6.1", rls:"UBUNTU7.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"libmono0-dbg", ver:"1.2.4-6ubuntu6.1", rls:"UBUNTU7.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"libmono0", ver:"1.2.4-6ubuntu6.1", rls:"UBUNTU7.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"mono-common", ver:"1.2.4-6ubuntu6.1", rls:"UBUNTU7.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"mono-devel", ver:"1.2.4-6ubuntu6.1", rls:"UBUNTU7.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"mono-jay", ver:"1.2.4-6ubuntu6.1", rls:"UBUNTU7.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"mono-jit-dbg", ver:"1.2.4-6ubuntu6.1", rls:"UBUNTU7.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"mono-jit", ver:"1.2.4-6ubuntu6.1", rls:"UBUNTU7.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"mono-runtime", ver:"1.2.4-6ubuntu6.1", rls:"UBUNTU7.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"mono-utils", ver:"1.2.4-6ubuntu6.1", rls:"UBUNTU7.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"mono", ver:"1.2.4-6ubuntu6.1", rls:"UBUNTU7.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"libmono-accessibility1.0-cil", ver:"1.2.4-6ubuntu6.1", rls:"UBUNTU7.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"libmono-accessibility2.0-cil", ver:"1.2.4-6ubuntu6.1", rls:"UBUNTU7.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"libmono-cairo1.0-cil", ver:"1.2.4-6ubuntu6.1", rls:"UBUNTU7.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"libmono-cairo2.0-cil", ver:"1.2.4-6ubuntu6.1", rls:"UBUNTU7.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"libmono-corlib1.0-cil", ver:"1.2.4-6ubuntu6.1", rls:"UBUNTU7.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"libmono-corlib2.0-cil", ver:"1.2.4-6ubuntu6.1", rls:"UBUNTU7.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"libmono-data-tds1.0-cil", ver:"1.2.4-6ubuntu6.1", rls:"UBUNTU7.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"libmono-data-tds2.0-cil", ver:"1.2.4-6ubuntu6.1", rls:"UBUNTU7.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"libmono-microsoft-build2.0-cil", ver:"1.2.4-6ubuntu6.1", rls:"UBUNTU7.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"libmono-peapi1.0-cil", ver:"1.2.4-6ubuntu6.1", rls:"UBUNTU7.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"libmono-peapi2.0-cil", ver:"1.2.4-6ubuntu6.1", rls:"UBUNTU7.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"libmono-relaxng1.0-cil", ver:"1.2.4-6ubuntu6.1", rls:"UBUNTU7.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"libmono-security1.0-cil", ver:"1.2.4-6ubuntu6.1", rls:"UBUNTU7.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"libmono-security2.0-cil", ver:"1.2.4-6ubuntu6.1", rls:"UBUNTU7.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"libmono-sharpzip0.6-cil", ver:"1.2.4-6ubuntu6.1", rls:"UBUNTU7.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"libmono-sharpzip0.84-cil", ver:"1.2.4-6ubuntu6.1", rls:"UBUNTU7.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"libmono-sharpzip2.84-cil", ver:"1.2.4-6ubuntu6.1", rls:"UBUNTU7.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"libmono-sqlite1.0-cil", ver:"1.2.4-6ubuntu6.1", rls:"UBUNTU7.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"libmono-sqlite2.0-cil", ver:"1.2.4-6ubuntu6.1", rls:"UBUNTU7.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"libmono-system-data1.0-cil", ver:"1.2.4-6ubuntu6.1", rls:"UBUNTU7.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"libmono-system-data2.0-cil", ver:"1.2.4-6ubuntu6.1", rls:"UBUNTU7.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"libmono-system-runtime1.0-cil", ver:"1.2.4-6ubuntu6.1", rls:"UBUNTU7.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"libmono-system-runtime2.0-cil", ver:"1.2.4-6ubuntu6.1", rls:"UBUNTU7.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"libmono-system-web1.0-cil", ver:"1.2.4-6ubuntu6.1", rls:"UBUNTU7.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"libmono-system-web2.0-cil", ver:"1.2.4-6ubuntu6.1", rls:"UBUNTU7.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"libmono-system1.0-cil", ver:"1.2.4-6ubuntu6.1", rls:"UBUNTU7.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"libmono-system2.0-cil", ver:"1.2.4-6ubuntu6.1", rls:"UBUNTU7.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"libmono-winforms1.0-cil", ver:"1.2.4-6ubuntu6.1", rls:"UBUNTU7.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"libmono-winforms2.0-cil", ver:"1.2.4-6ubuntu6.1", rls:"UBUNTU7.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"libmono1.0-cil", ver:"1.2.4-6ubuntu6.1", rls:"UBUNTU7.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"libmono2.0-cil", ver:"1.2.4-6ubuntu6.1", rls:"UBUNTU7.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"mono-dbg", ver:"1.2.4-6ubuntu6.1", rls:"UBUNTU7.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"mono-gac", ver:"1.2.4-6ubuntu6.1", rls:"UBUNTU7.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"mono-gmcs", ver:"1.2.4-6ubuntu6.1", rls:"UBUNTU7.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"mono-mcs", ver:"1.2.4-6ubuntu6.1", rls:"UBUNTU7.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"libmono-bytefx0.7.6.1-cil", ver:"1.2.4-6ubuntu6.1", rls:"UBUNTU7.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"libmono-bytefx0.7.6.2-cil", ver:"1.2.4-6ubuntu6.1", rls:"UBUNTU7.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"libmono-c5", ver:"1.0-cil_1.2.4-6ubuntu6.1", rls:"UBUNTU7.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"libmono-cscompmgd7.0-cil", ver:"1.2.4-6ubuntu6.1", rls:"UBUNTU7.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"libmono-cscompmgd8.0-cil", ver:"1.2.4-6ubuntu6.1", rls:"UBUNTU7.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"libmono-firebirdsql1.7-cil", ver:"1.2.4-6ubuntu6.1", rls:"UBUNTU7.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"libmono-ldap1.0-cil", ver:"1.2.4-6ubuntu6.1", rls:"UBUNTU7.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"libmono-ldap2.0-cil", ver:"1.2.4-6ubuntu6.1", rls:"UBUNTU7.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"libmono-microsoft7.0-cil", ver:"1.2.4-6ubuntu6.1", rls:"UBUNTU7.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"libmono-microsoft8.0-cil", ver:"1.2.4-6ubuntu6.1", rls:"UBUNTU7.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"libmono-npgsql1.0-cil", ver:"1.2.4-6ubuntu6.1", rls:"UBUNTU7.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"libmono-npgsql2.0-cil", ver:"1.2.4-6ubuntu6.1", rls:"UBUNTU7.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"libmono-oracle1.0-cil", ver:"1.2.4-6ubuntu6.1", rls:"UBUNTU7.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"libmono-oracle2.0-cil", ver:"1.2.4-6ubuntu6.1", rls:"UBUNTU7.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"libmono-relaxng2.0-cil", ver:"1.2.4-6ubuntu6.1", rls:"UBUNTU7.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"libmono-sharpzip2.6-cil", ver:"1.2.4-6ubuntu6.1", rls:"UBUNTU7.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"libmono-system-ldap1.0-cil", ver:"1.2.4-6ubuntu6.1", rls:"UBUNTU7.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"libmono-system-ldap2.0-cil", ver:"1.2.4-6ubuntu6.1", rls:"UBUNTU7.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"libmono-system-messaging1.0-cil", ver:"1.2.4-6ubuntu6.1", rls:"UBUNTU7.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"libmono-system-messaging2.0-cil", ver:"1.2.4-6ubuntu6.1", rls:"UBUNTU7.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"mono-mjs", ver:"1.2.4-6ubuntu6.1", rls:"UBUNTU7.10"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}