###############################################################################
# OpenVAS Vulnerability Test
#
# Ubuntu Update for xorg-server vulnerabilities USN-616-1
#
# Authors:
# System Generated Check
#
# Copyright:
# Copyright (c) 2009 Intevation GmbH, http://www.intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(840329);
  script_version("$Revision: 1.0 $");
  script_xref(name: "USN", value: "616-1");
  script_cve_id("CVE-2008-1377", "CVE-2008-1379", "CVE-2008-2360", "CVE-2008-2361", "CVE-2008-2362");
  script_name( "Ubuntu Update for xorg-server vulnerabilities USN-616-1");
  desc = "

  Vulnerability Insight:

  Multiple flaws were found in the RENDER, RECORD, and Security
  extensions of X.org which did not correctly validate function arguments.
  An authenticated attacker could send specially crafted requests and gain
  root privileges or crash X. (CVE-2008-1377, CVE-2008-2360, CVE-2008-2361,
  CVE-2008-2362)
  
  It was discovered that the MIT-SHM extension of X.org did not correctly
  validate the location of memory during an image copy.  An authenticated
  attacker could exploit this to read arbitrary memory locations within X,
  exposing sensitive information. (CVE-2008-1379)

  Affected Software/OS:
  xorg-server vulnerabilities on Ubuntu 6.06 LTS ,
  Ubuntu 7.04 ,
  Ubuntu 7.10 ,
  Ubuntu 8.04 LTS

  Fix: Please Install the Updated Packages.

  References:
  https://lists.ubuntu.com/archives/ubuntu-security-announce/2008-June/000718.html

  Risk factor: High";

  script_description(desc);
  script_summary("Check for the Version of xorg-server vulnerabilities");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (C) 2009 Intevation GmbH");
  script_family("Ubuntu Local Security Checks");
  script_dependencies("gather-package-list.nasl");
  script_require_keys("ssh/login/release");
  exit(0);
}


include("pkg-lib-deb.inc");
include("revisions-lib.inc");

release = get_kb_item("ssh/login/release");

if(release == NULL){
  exit(0);
}

if(release == "UBUNTU6.06 LTS")
{

  if(isdpkgvuln(pkg:"xnest", ver:"1.0.2-0ubuntu10.13", rls:"UBUNTU6.06 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"xserver-xorg-core", ver:"1.0.2-0ubuntu10.13", rls:"UBUNTU6.06 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"xserver-xorg-dev", ver:"1.0.2-0ubuntu10.13", rls:"UBUNTU6.06 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"xvfb", ver:"1.0.2-0ubuntu10.13", rls:"UBUNTU6.06 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"xdmx-tools", ver:"1.0.2-0ubuntu10.13", rls:"UBUNTU6.06 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"xdmx", ver:"1.0.2-0ubuntu10.13", rls:"UBUNTU6.06 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}


if(release == "UBUNTU7.04")
{

  if(isdpkgvuln(pkg:"xnest", ver:"1.2.0-3ubuntu8.4", rls:"UBUNTU7.04"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"xserver-xorg-core", ver:"1.2.0-3ubuntu8.4", rls:"UBUNTU7.04"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"xserver-xorg-dev", ver:"1.2.0-3ubuntu8.4", rls:"UBUNTU7.04"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"xvfb", ver:"1.2.0-3ubuntu8.4", rls:"UBUNTU7.04"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"xdmx-tools", ver:"1.2.0-3ubuntu8.4", rls:"UBUNTU7.04"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"xdmx", ver:"1.2.0-3ubuntu8.4", rls:"UBUNTU7.04"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"xserver-xephyr", ver:"1.2.0-3ubuntu8.4", rls:"UBUNTU7.04"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}


if(release == "UBUNTU8.04 LTS")
{

  if(isdpkgvuln(pkg:"xnest", ver:"1.4.1~git20080131-1ubuntu9.2", rls:"UBUNTU8.04 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"xserver-xephyr", ver:"1.4.1~git20080131-1ubuntu9.2", rls:"UBUNTU8.04 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"xserver-xorg-core-dbg", ver:"1.4.1~git20080131-1ubuntu9.2", rls:"UBUNTU8.04 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"xserver-xorg-core", ver:"1.4.1~git20080131-1ubuntu9.2", rls:"UBUNTU8.04 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"xserver-xorg-dev", ver:"1.4.1~git20080131-1ubuntu9.2", rls:"UBUNTU8.04 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"xvfb", ver:"1.4.1~git20080131-1ubuntu9.2", rls:"UBUNTU8.04 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}


if(release == "UBUNTU7.10")
{

  if(isdpkgvuln(pkg:"xnest", ver:"1.3.0.0.dfsg-12ubuntu8.4", rls:"UBUNTU7.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"xserver-xephyr", ver:"1.3.0.0.dfsg-12ubuntu8.4", rls:"UBUNTU7.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"xserver-xorg-core-dbg", ver:"1.3.0.0.dfsg-12ubuntu8.4", rls:"UBUNTU7.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"xserver-xorg-core", ver:"1.3.0.0.dfsg-12ubuntu8.4", rls:"UBUNTU7.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"xserver-xorg-dev", ver:"1.3.0.0.dfsg-12ubuntu8.4", rls:"UBUNTU7.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"xvfb", ver:"1.3.0.0.dfsg-12ubuntu8.4", rls:"UBUNTU7.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"xdmx-tools", ver:"1.3.0.0.dfsg-12ubuntu8.4", rls:"UBUNTU7.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"xdmx", ver:"1.3.0.0.dfsg-12ubuntu8.4", rls:"UBUNTU7.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"xprint", ver:"1.3.0.0.dfsg-12ubuntu8.4", rls:"UBUNTU7.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"xprint-common", ver:"1.3.0.0.dfsg-12ubuntu8.4", rls:"UBUNTU7.10"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}