###############################################################################
# OpenVAS Vulnerability Test
#
# Ubuntu Update for devhelp, epiphany-browser, midbrowser, yelp update USN-626-2
#
# Authors:
# System Generated Check
#
# Copyright:
# Copyright (c) 2009 Intevation GmbH, http://www.intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(840226);
  script_version("$Revision: 1.0 $");
  script_xref(name: "USN", value: "626-2");
  script_cve_id("CVE-2008-2785", "CVE-2008-2933");
  script_name( "Ubuntu Update for devhelp, epiphany-browser, midbrowser, yelp update USN-626-2");
  desc = "

  Vulnerability Insight:

  USN-626-1 fixed vulnerabilities in xulrunner-1.9. The changes required
  that Devhelp, Epiphany, Midbrowser and Yelp also be updated to use the
  new xulrunner-1.9.
  
  Original advisory details:
  
  A flaw was discovered in the browser engine. A variable could be made to
  overflow causing the browser to crash. If a user were tricked into opening
  a malicious web page, an attacker could cause a denial of service or
  possibly execute arbitrary code with the privileges of the user invoking
  the program. (CVE-2008-2785)
  
  Billy Rios discovered that Firefox and xulrunner, as used by browsers
  such as Epiphany, did not properly perform URI splitting with pipe
  symbols when passed a command-line URI. If Firefox or xulrunner were
  passed a malicious URL, an attacker may be able to execute local
  content with chrome privileges. (CVE-2008-2933)

  Affected Software/OS:
  devhelp, epiphany-browser, midbrowser, yelp update on Ubuntu 8.04 LTS

  Fix: Please Install the Updated Packages.

  References:
  https://lists.ubuntu.com/archives/ubuntu-security-announce/2008-August/000739.html

  Risk factor: High";

  script_description(desc);
  script_summary("Check for the Version of devhelp, epiphany-browser, midbrowser, yelp update");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (C) 2009 Intevation GmbH");
  script_family("Ubuntu Local Security Checks");
  script_dependencies("gather-package-list.nasl");
  script_require_keys("ssh/login/release");
  exit(0);
}


include("pkg-lib-deb.inc");
include("revisions-lib.inc");

release = get_kb_item("ssh/login/release");

if(release == NULL){
  exit(0);
}

if(release == "UBUNTU8.04 LTS")
{

  if(isdpkgvuln(pkg:"devhelp", ver:"0.19-1ubuntu1.8.04.3", rls:"UBUNTU8.04 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"libdevhelp-1-0", ver:"0.19-1ubuntu1.8.04.3", rls:"UBUNTU8.04 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"libdevhelp-1-dev", ver:"0.19-1ubuntu1.8.04.3", rls:"UBUNTU8.04 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"epiphany-browser-dbg", ver:"2.22.2-0ubuntu0.8.04.5", rls:"UBUNTU8.04 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"epiphany-gecko", ver:"2.22.2-0ubuntu0.8.04.5", rls:"UBUNTU8.04 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"midbrowser", ver:"0.3.0rc1a-1~8.04.2", rls:"UBUNTU8.04 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"yelp", ver:"2.22.1-0ubuntu2.8.04.2", rls:"UBUNTU8.04 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"devhelp-common", ver:"0.19-1ubuntu1.8.04.3", rls:"UBUNTU8.04 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"epiphany-browser-data", ver:"2.22.2-0ubuntu0.8.04.5", rls:"UBUNTU8.04 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"epiphany-browser-dev", ver:"2.22.2-0ubuntu0.8.04.5", rls:"UBUNTU8.04 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"epiphany-browser", ver:"2.22.2-0ubuntu0.8.04.5", rls:"UBUNTU8.04 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}