###############################################################################
# OpenVAS Vulnerability Test
#
# Ubuntu Update for libxslt vulnerabilities USN-633-1
#
# Authors:
# System Generated Check
#
# Copyright:
# Copyright (c) 2009 Intevation GmbH, http://www.intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(840252);
  script_version("$Revision: 1.0 $");
  script_xref(name: "USN", value: "633-1");
  script_cve_id("CVE-2008-1767", "CVE-2008-2935");
  script_name( "Ubuntu Update for libxslt vulnerabilities USN-633-1");
  desc = "

  Vulnerability Insight:

  It was discovered that long transformation matches in libxslt could
  overflow.  If an attacker were able to make an application linked against
  libxslt process malicious XSL style sheet input, they could execute
  arbitrary code with user privileges or cause the application to crash,
  leading to a denial of serivce. (CVE-2008-1767)
  
  Chris Evans discovered that the RC4 processing code in libxslt did not
  correctly handle corrupted key information.  If a remote attacker were
  able to make an application linked against libxslt process malicious
  XML input, they could crash the application, leading to a denial of
  service. (CVE-2008-2935)

  Affected Software/OS:
  libxslt vulnerabilities on Ubuntu 6.06 LTS ,
  Ubuntu 7.04 ,
  Ubuntu 7.10 ,
  Ubuntu 8.04 LTS

  Fix: Please Install the Updated Packages.

  References:
  https://lists.ubuntu.com/archives/ubuntu-security-announce/2008-August/000737.html

  Risk factor: High";

  script_description(desc);
  script_summary("Check for the Version of libxslt vulnerabilities");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (C) 2009 Intevation GmbH");
  script_family("Ubuntu Local Security Checks");
  script_dependencies("gather-package-list.nasl");
  script_require_keys("ssh/login/release");
  exit(0);
}


include("pkg-lib-deb.inc");
include("revisions-lib.inc");

release = get_kb_item("ssh/login/release");

if(release == NULL){
  exit(0);
}

if(release == "UBUNTU6.06 LTS")
{

  if(isdpkgvuln(pkg:"libxslt1-dev", ver:"1.1.15-1ubuntu1.2", rls:"UBUNTU6.06 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"libxslt1.1", ver:"1.1.15-1ubuntu1.2", rls:"UBUNTU6.06 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"python2.4-libxslt1", ver:"1.1.15-1ubuntu1.2", rls:"UBUNTU6.06 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"xsltproc", ver:"1.1.15-1ubuntu1.2", rls:"UBUNTU6.06 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"python-libxslt1", ver:"1.1.15-1ubuntu1.2", rls:"UBUNTU6.06 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}


if(release == "UBUNTU7.04")
{

  if(isdpkgvuln(pkg:"libxslt1-dbg", ver:"1.1.20-0ubuntu2.2", rls:"UBUNTU7.04"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"libxslt1-dev", ver:"1.1.20-0ubuntu2.2", rls:"UBUNTU7.04"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"libxslt1.1", ver:"1.1.20-0ubuntu2.2", rls:"UBUNTU7.04"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"python-libxslt1-dbg", ver:"1.1.20-0ubuntu2.2", rls:"UBUNTU7.04"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"python-libxslt1", ver:"1.1.20-0ubuntu2.2", rls:"UBUNTU7.04"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"xsltproc", ver:"1.1.20-0ubuntu2.2", rls:"UBUNTU7.04"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}


if(release == "UBUNTU8.04 LTS")
{

  if(isdpkgvuln(pkg:"libxslt1-dbg", ver:"1.1.22-1ubuntu1.2", rls:"UBUNTU8.04 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"libxslt1-dev", ver:"1.1.22-1ubuntu1.2", rls:"UBUNTU8.04 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"libxslt1.1", ver:"1.1.22-1ubuntu1.2", rls:"UBUNTU8.04 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"python-libxslt1-dbg", ver:"1.1.22-1ubuntu1.2", rls:"UBUNTU8.04 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"python-libxslt1", ver:"1.1.22-1ubuntu1.2", rls:"UBUNTU8.04 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"xsltproc", ver:"1.1.22-1ubuntu1.2", rls:"UBUNTU8.04 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}


if(release == "UBUNTU7.10")
{

  if(isdpkgvuln(pkg:"libxslt1-dbg", ver:"1.1.21-2ubuntu2.2", rls:"UBUNTU7.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"libxslt1-dev", ver:"1.1.21-2ubuntu2.2", rls:"UBUNTU7.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"libxslt1.1", ver:"1.1.21-2ubuntu2.2", rls:"UBUNTU7.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"python-libxslt1-dbg", ver:"1.1.21-2ubuntu2.2", rls:"UBUNTU7.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"python-libxslt1", ver:"1.1.21-2ubuntu2.2", rls:"UBUNTU7.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"xsltproc", ver:"1.1.21-2ubuntu2.2", rls:"UBUNTU7.10"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}