###############################################################################
# OpenVAS Vulnerability Test
#
# Ubuntu Update for libxml2 vulnerabilities USN-644-1
#
# Authors:
# System Generated Check
#
# Copyright:
# Copyright (c) 2009 Intevation GmbH, http://www.intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(840208);
  script_version("$Revision: 1.0 $");
  script_xref(name: "USN", value: "644-1");
  script_cve_id("CVE-2008-3281", "CVE-2008-3529");
  script_name( "Ubuntu Update for libxml2 vulnerabilities USN-644-1");
  desc = "

  Vulnerability Insight:

  It was discovered that libxml2 did not correctly handle long entity names.
  If a user were tricked into processing a specially crafted XML document,
  a remote attacker could execute arbitrary code with user privileges
  or cause the application linked against libxml2 to crash, leading to a
  denial of service. (CVE-2008-3529)
  
  USN-640-1 fixed vulnerabilities in libxml2.  When processing extremely
  large XML documents with valid entities, it was possible to incorrectly
  trigger the newly added vulnerability protections.  This update fixes
  the problem.  (CVE-2008-3281)

  Affected Software/OS:
  libxml2 vulnerabilities on Ubuntu 6.06 LTS ,
  Ubuntu 7.04 ,
  Ubuntu 7.10 ,
  Ubuntu 8.04 LTS

  Fix: Please Install the Updated Packages.

  References:
  https://lists.ubuntu.com/archives/ubuntu-security-announce/2008-September/000749.html

  Risk factor: High";

  script_description(desc);
  script_summary("Check for the Version of libxml2 vulnerabilities");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (C) 2009 Intevation GmbH");
  script_family("Ubuntu Local Security Checks");
  script_dependencies("gather-package-list.nasl");
  script_require_keys("ssh/login/release");
  exit(0);
}


include("pkg-lib-deb.inc");
include("revisions-lib.inc");

release = get_kb_item("ssh/login/release");

if(release == NULL){
  exit(0);
}

if(release == "UBUNTU6.06 LTS")
{

  if(isdpkgvuln(pkg:"libxml2-dbg", ver:"2.6.24.dfsg-1ubuntu1.3", rls:"UBUNTU6.06 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"libxml2-dev", ver:"2.6.24.dfsg-1ubuntu1.3", rls:"UBUNTU6.06 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"libxml2-utils", ver:"2.6.24.dfsg-1ubuntu1.3", rls:"UBUNTU6.06 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"libxml2", ver:"2.6.24.dfsg-1ubuntu1.3", rls:"UBUNTU6.06 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"python2.4-libxml2", ver:"2.6.24.dfsg-1ubuntu1.3", rls:"UBUNTU6.06 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"libxml2-doc", ver:"2.6.24.dfsg-1ubuntu1.3", rls:"UBUNTU6.06 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"python-libxml2", ver:"2.6.24.dfsg-1ubuntu1.3", rls:"UBUNTU6.06 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}


if(release == "UBUNTU7.04")
{

  if(isdpkgvuln(pkg:"libxml2-dbg", ver:"2.6.27.dfsg-1ubuntu3.3", rls:"UBUNTU7.04"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"libxml2-dev", ver:"2.6.27.dfsg-1ubuntu3.3", rls:"UBUNTU7.04"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"libxml2-utils", ver:"2.6.27.dfsg-1ubuntu3.3", rls:"UBUNTU7.04"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"libxml2", ver:"2.6.27.dfsg-1ubuntu3.3", rls:"UBUNTU7.04"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"python-libxml2-dbg", ver:"2.6.27.dfsg-1ubuntu3.3", rls:"UBUNTU7.04"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"python-libxml2", ver:"2.6.27.dfsg-1ubuntu3.3", rls:"UBUNTU7.04"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"libxml2-doc", ver:"2.6.27.dfsg-1ubuntu3.3", rls:"UBUNTU7.04"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}


if(release == "UBUNTU8.04 LTS")
{

  if(isdpkgvuln(pkg:"libxml2-dbg", ver:"2.6.31.dfsg-2ubuntu1.2", rls:"UBUNTU8.04 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"libxml2-dev", ver:"2.6.31.dfsg-2ubuntu1.2", rls:"UBUNTU8.04 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"libxml2-utils", ver:"2.6.31.dfsg-2ubuntu1.2", rls:"UBUNTU8.04 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"libxml2", ver:"2.6.31.dfsg-2ubuntu1.2", rls:"UBUNTU8.04 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"python-libxml2-dbg", ver:"2.6.31.dfsg-2ubuntu1.2", rls:"UBUNTU8.04 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"python-libxml2", ver:"2.6.31.dfsg-2ubuntu1.2", rls:"UBUNTU8.04 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"libxml2-doc", ver:"2.6.31.dfsg-2ubuntu1.2", rls:"UBUNTU8.04 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}


if(release == "UBUNTU7.10")
{

  if(isdpkgvuln(pkg:"libxml2-dbg", ver:"2.6.30.dfsg-2ubuntu1.3", rls:"UBUNTU7.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"libxml2-dev", ver:"2.6.30.dfsg-2ubuntu1.3", rls:"UBUNTU7.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"libxml2-utils", ver:"2.6.30.dfsg-2ubuntu1.3", rls:"UBUNTU7.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"libxml2", ver:"2.6.30.dfsg-2ubuntu1.3", rls:"UBUNTU7.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"python-libxml2-dbg", ver:"2.6.30.dfsg-2ubuntu1.3", rls:"UBUNTU7.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"python-libxml2", ver:"2.6.30.dfsg-2ubuntu1.3", rls:"UBUNTU7.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"libxml2-doc", ver:"2.6.30.dfsg-2ubuntu1.3", rls:"UBUNTU7.10"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}