###############################################################################
# OpenVAS Vulnerability Test
#
# Ubuntu Update for mozilla-thunderbird, thunderbird vulnerabilities USN-647-1
#
# Authors:
# System Generated Check
#
# Copyright:
# Copyright (c) 2009 Intevation GmbH, http://www.intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(840269);
  script_version("$Revision: 1.0 $");
  script_xref(name: "USN", value: "647-1");
  script_cve_id("CVE-2008-3835", "CVE-2008-4058", "CVE-2008-4059", "CVE-2008-4060", "CVE-2008-4061", "CVE-2008-4062", "CVE-2008-4063", "CVE-2008-4064", "CVE-2008-4065", "CVE-2008-4066", "CVE-2008-4067", "CVE-2008-4068", "CVE-2008-4070");
  script_name( "Ubuntu Update for mozilla-thunderbird, thunderbird vulnerabilities USN-647-1");
  desc = "

  Vulnerability Insight:

  It was discovered that the same-origin check in Thunderbird could
  be bypassed. If a user had JavaScript enabled and were tricked into
  opening a malicious website, an attacker may be able to execute
  JavaScript in the context of a different website. (CVE-2008-3835)
  
  Several problems were discovered in the browser engine of
  Thunderbird. If a user had JavaScript enabled, this could allow an
  attacker to execute code with chrome privileges. (CVE-2008-4058,
  CVE-2008-4059, CVE-2008-4060)
  
  Drew Yao, David Maciejak and other Mozilla developers found several
  problems in the browser engine of Thunderbird. If a user had
  JavaScript enabled and were tricked into opening a malicious web
  page, an attacker could cause a denial of service or possibly
  execute arbitrary code with the privileges of the user invoking the
  program. (CVE-2008-4061, CVE-2008-4062, CVE-2008-4063, CVE-2008-4064)
  
  Dave Reed discovered a flaw in the JavaScript parsing code when
  processing certain BOM characters. An attacker could exploit this
  to bypass script filters and perform cross-site scripting attacks
  if a user had JavaScript enabled. (CVE-2008-4065)
  
  Gareth Heyes discovered a flaw in the HTML parser of Thunderbird. If
  a user had JavaScript enabled and were tricked into opening a
  malicious web page, an attacker could bypass script filtering and
  perform cross-site scripting attacks. (CVE-2008-4066)
  
  Boris Zbarsky and Georgi Guninski independently discovered flaws in
  the resource: protocol. An attacker could exploit this to perform
  directory traversal, read information about the system, and prompt
  the user to save information in a file. (CVE-2008-4067,
  CVE-2008-4068)
  
  Georgi Guninski discovered that Thunderbird improperly handled
  cancelled newsgroup messages. If a user opened a crafted newsgroup
  message, an attacker could cause a buffer overrun and potentially
  execute arbitrary code with the privileges of the user invoking the
  program. (CVE-2008-4070)

  Affected Software/OS:
  mozilla-thunderbird, thunderbird vulnerabilities on Ubuntu 6.06 LTS ,
  Ubuntu 7.04 ,
  Ubuntu 7.10 ,
  Ubuntu 8.04 LTS

  Fix: Please Install the Updated Packages.

  References:
  https://lists.ubuntu.com/archives/ubuntu-security-announce/2008-September/000754.html

  Risk factor: High";

  script_description(desc);
  script_summary("Check for the Version of mozilla-thunderbird, thunderbird vulnerabilities");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (C) 2009 Intevation GmbH");
  script_family("Ubuntu Local Security Checks");
  script_dependencies("gather-package-list.nasl");
  script_require_keys("ssh/login/release");
  exit(0);
}


include("pkg-lib-deb.inc");
include("revisions-lib.inc");

release = get_kb_item("ssh/login/release");

if(release == NULL){
  exit(0);
}

if(release == "UBUNTU6.06 LTS")
{

  if(isdpkgvuln(pkg:"mozilla-thunderbird-dev", ver:"1.5.0.13+1.5.0.15~prepatch080614g-0ubuntu0.6.06.1", rls:"UBUNTU6.06 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"mozilla-thunderbird-inspector", ver:"1.5.0.13+1.5.0.15~prepatch080614g-0ubuntu0.6.06.1", rls:"UBUNTU6.06 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"mozilla-thunderbird-typeaheadfind", ver:"1.5.0.13+1.5.0.15~prepatch080614g-0ubuntu0.6.06.1", rls:"UBUNTU6.06 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"mozilla-thunderbird", ver:"1.5.0.13+1.5.0.15~prepatch080614g-0ubuntu0.6.06.1", rls:"UBUNTU6.06 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}


if(release == "UBUNTU7.04")
{

  if(isdpkgvuln(pkg:"mozilla-thunderbird-dev", ver:"1.5.0.13+1.5.0.15~prepatch080614g-0ubuntu0.7.04.1", rls:"UBUNTU7.04"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"mozilla-thunderbird-inspector", ver:"1.5.0.13+1.5.0.15~prepatch080614g-0ubuntu0.7.04.1", rls:"UBUNTU7.04"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"mozilla-thunderbird-typeaheadfind", ver:"1.5.0.13+1.5.0.15~prepatch080614g-0ubuntu0.7.04.1", rls:"UBUNTU7.04"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"mozilla-thunderbird", ver:"1.5.0.13+1.5.0.15~prepatch080614g-0ubuntu0.7.04.1", rls:"UBUNTU7.04"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}


if(release == "UBUNTU8.04 LTS")
{

  if(isdpkgvuln(pkg:"thunderbird-dev", ver:"2.0.0.17+nobinonly-0ubuntu0.8.04.1", rls:"UBUNTU8.04 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"thunderbird-gnome-support", ver:"2.0.0.17+nobinonly-0ubuntu0.8.04.1", rls:"UBUNTU8.04 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"thunderbird", ver:"2.0.0.17+nobinonly-0ubuntu0.8.04.1", rls:"UBUNTU8.04 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"mozilla-thunderbird-dev", ver:"2.0.0.17+nobinonly-0ubuntu0.8.04.1", rls:"UBUNTU8.04 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"mozilla-thunderbird", ver:"2.0.0.17+nobinonly-0ubuntu0.8.04.1", rls:"UBUNTU8.04 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}


if(release == "UBUNTU7.10")
{

  if(isdpkgvuln(pkg:"thunderbird-dev", ver:"2.0.0.17+nobinonly-0ubuntu0.7.10.1", rls:"UBUNTU7.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"thunderbird-gnome-support", ver:"2.0.0.17+nobinonly-0ubuntu0.7.10.1", rls:"UBUNTU7.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"thunderbird", ver:"2.0.0.17+nobinonly-0ubuntu0.7.10.1", rls:"UBUNTU7.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"mozilla-thunderbird-dev", ver:"2.0.0.17+nobinonly-0ubuntu0.7.10.1", rls:"UBUNTU7.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"mozilla-thunderbird", ver:"2.0.0.17+nobinonly-0ubuntu0.7.10.1", rls:"UBUNTU7.10"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}