###############################################################################
# OpenVAS Vulnerability Test
#
# Ubuntu Update for dbus vulnerabilities USN-653-1
#
# Authors:
# System Generated Check
#
# Copyright:
# Copyright (c) 2009 Intevation GmbH, http://www.intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(840202);
  script_version("$Revision: 1.0 $");
  script_xref(name: "USN", value: "653-1");
  script_cve_id("CVE-2008-0595", "CVE-2008-3834");
  script_name( "Ubuntu Update for dbus vulnerabilities USN-653-1");
  desc = "

  Vulnerability Insight:

  Havoc Pennington discovered that the D-Bus daemon did not correctly
  validate certain security policies.  If a local user sent a specially
  crafted D-Bus request, they could bypass security policies that had a
  &quot;send_interface&quot; defined. (CVE-2008-0595)
  
  It was discovered that the D-Bus library did not correctly validate
  certain corrupted signatures.  If a local user sent a specially crafted
  D-Bus request, they could crash applications linked against the D-Bus
  library, leading to a denial of service. (CVE-2008-3834)

  Affected Software/OS:
  dbus vulnerabilities on Ubuntu 6.06 LTS ,
  Ubuntu 7.04 ,
  Ubuntu 7.10 ,
  Ubuntu 8.04 LTS

  Fix: Please Install the Updated Packages.

  References:
  https://lists.ubuntu.com/archives/ubuntu-security-announce/2008-October/000761.html

  Risk factor: High";

  script_description(desc);
  script_summary("Check for the Version of dbus vulnerabilities");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (C) 2009 Intevation GmbH");
  script_family("Ubuntu Local Security Checks");
  script_dependencies("gather-package-list.nasl");
  script_require_keys("ssh/login/release");
  exit(0);
}


include("pkg-lib-deb.inc");
include("revisions-lib.inc");

release = get_kb_item("ssh/login/release");

if(release == NULL){
  exit(0);
}

if(release == "UBUNTU6.06 LTS")
{

  if(isdpkgvuln(pkg:"dbus-1-utils", ver:"0.60-6ubuntu8.3", rls:"UBUNTU6.06 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"dbus", ver:"0.60-6ubuntu8.3", rls:"UBUNTU6.06 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"libdbus-1-2", ver:"0.60-6ubuntu8.3", rls:"UBUNTU6.06 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"libdbus-1-dev", ver:"0.60-6ubuntu8.3", rls:"UBUNTU6.06 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"libdbus-glib-1-2", ver:"0.60-6ubuntu8.3", rls:"UBUNTU6.06 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"libdbus-glib-1-dev", ver:"0.60-6ubuntu8.3", rls:"UBUNTU6.06 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"libdbus-qt-1-1c2", ver:"0.60-6ubuntu8.3", rls:"UBUNTU6.06 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"libdbus-qt-1-dev", ver:"0.60-6ubuntu8.3", rls:"UBUNTU6.06 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"python2.4-dbus", ver:"0.60-6ubuntu8.3", rls:"UBUNTU6.06 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"dbus-1-doc", ver:"0.60-6ubuntu8.3", rls:"UBUNTU6.06 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"libdbus-1-cil", ver:"0.60-6ubuntu8.3", rls:"UBUNTU6.06 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"monodoc-dbus-1-manual", ver:"0.60-6ubuntu8.3", rls:"UBUNTU6.06 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}


if(release == "UBUNTU7.04")
{

  if(isdpkgvuln(pkg:"dbus-1-utils", ver:"1.0.2-1ubuntu4.2", rls:"UBUNTU7.04"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"dbus", ver:"1.0.2-1ubuntu4.2", rls:"UBUNTU7.04"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"libdbus-1-3", ver:"1.0.2-1ubuntu4.2", rls:"UBUNTU7.04"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"libdbus-1-dev", ver:"1.0.2-1ubuntu4.2", rls:"UBUNTU7.04"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"dbus-1-doc", ver:"1.0.2-1ubuntu4.2", rls:"UBUNTU7.04"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}


if(release == "UBUNTU8.04 LTS")
{

  if(isdpkgvuln(pkg:"dbus-x11", ver:"1.1.20-1ubuntu3.1", rls:"UBUNTU8.04 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"dbus", ver:"1.1.20-1ubuntu3.1", rls:"UBUNTU8.04 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"libdbus-1-3", ver:"1.1.20-1ubuntu3.1", rls:"UBUNTU8.04 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"libdbus-1-dev", ver:"1.1.20-1ubuntu3.1", rls:"UBUNTU8.04 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"dbus-1-doc", ver:"1.1.20-1ubuntu3.1", rls:"UBUNTU8.04 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}


if(release == "UBUNTU7.10")
{

  if(isdpkgvuln(pkg:"dbus-x11", ver:"1.1.1-3ubuntu4.2", rls:"UBUNTU7.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"dbus", ver:"1.1.1-3ubuntu4.2", rls:"UBUNTU7.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"libdbus-1-3", ver:"1.1.1-3ubuntu4.2", rls:"UBUNTU7.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"libdbus-1-dev", ver:"1.1.1-3ubuntu4.2", rls:"UBUNTU7.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"dbus-1-doc", ver:"1.1.1-3ubuntu4.2", rls:"UBUNTU7.10"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}