###############################################################################
# OpenVAS Vulnerability Test
#
# Ubuntu Update for firefox, firefox-3.0, xulrunner-1.9 vulnerabilities USN-667-1
#
# Authors:
# System Generated Check
#
# Copyright:
# Copyright (c) 2009 Intevation GmbH, http://www.intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(840223);
  script_version("$Revision: 1.0 $");
  script_xref(name: "USN", value: "667-1");
  script_cve_id("CVE-2008-0017", "CVE-2008-4582", "CVE-2008-5012", "CVE-2008-5013", "CVE-2008-5014", "CVE-2008-5015", "CVE-2008-5016", "CVE-2008-5017", "CVE-2008-5018", "CVE-2008-5019", "CVE-2008-5021", "CVE-2008-5022", "CVE-2008-5023", "CVE-2008-5024");
  script_name( "Ubuntu Update for firefox, firefox-3.0, xulrunner-1.9 vulnerabilities USN-667-1");
  desc = "

  Vulnerability Insight:

  Liu Die Yu discovered an information disclosure vulnerability in Firefox
  when using saved .url shortcut files. If a user were tricked into
  downloading a crafted .url file and a crafted HTML file, an attacker
  could steal information from the user's cache. (CVE-2008-4582)
  
  Georgi Guninski, Michal Zalewsk and Chris Evans discovered that the
  same-origin check in Firefox could be bypassed. If a user were tricked
  into opening a malicious website, an attacker could obtain private
  information from data stored in the images, or discover information
  about software on the user's computer. This issue only affects Firefox 2.
  (CVE-2008-5012)
  
  It was discovered that Firefox did not properly check if the Flash
  module was properly unloaded. By tricking a user into opening a crafted
  SWF file, an attacker could cause Firefox to crash and possibly execute
  arbitrary code with user privileges. This issue only affects Firefox 2.
  (CVE-2008-5013)
  
  Jesse Ruderman discovered that Firefox did not properly guard locks on
  non-native objects. If a user were tricked into opening a malicious
  website, an attacker could cause a browser crash and possibly execute
  arbitrary code with user privileges. This issue only affects Firefox 2.
  (CVE-2008-5014)
  
  Luke Bryan discovered that Firefox sometimes opened file URIs with
  chrome privileges. If a user saved malicious code locally, then opened
  the file in the same tab as a privileged document, an attacker could
  run arbitrary JavaScript code with chrome privileges. This issue only
  affects Firefox 3.0. (CVE-2008-5015)
  
  Several problems were discovered in the browser, layout and JavaScript
  engines. These problems could allow an attacker to crash the browser
  and possibly execute arbitrary code with user privileges.
  (CVE-2008-5016, CVE-2008-5017, CVE-2008-5018)
  
  David Bloom discovered that the same-origin check in Firefox could be
  bypassed by utilizing the session restore feature. An attacker could
  exploit this to run JavaScript in the context of another site or
  execute arbitrary JavaScript code with chrome privileges.
  (CVE-2008-5019)
  
  Justin Schuh discovered a flaw in Firefox's mime-type parsing. If a
  user were tricked into opening a malicious website, an attacker could
  send a crafted header in the HTTP index response, causing a browser
  crash and execute arbitrary code with user privileges. (CVE-2008-0017)
  
  A flaw was discovered in Firefox's DOM constructing code. If a user
  were tricked into opening  ... 

  Description truncated, for more information please check the Reference URL

  Affected Software/OS:
  firefox, firefox-3.0, xulrunner-1.9 vulnerabilities on Ubuntu 6.06 LTS ,
  Ubuntu 7.10 ,
  Ubuntu 8.04 LTS ,
  Ubuntu 8.10

  Fix: Please Install the Updated Packages.

  References:
  https://lists.ubuntu.com/archives/ubuntu-security-announce/2008-November/000779.html

  Risk factor: High";

  script_description(desc);
  script_summary("Check for the Version of firefox, firefox-3.0, xulrunner-1.9 vulnerabilities");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (C) 2009 Intevation GmbH");
  script_family("Ubuntu Local Security Checks");
  script_dependencies("gather-package-list.nasl");
  script_require_keys("ssh/login/release");
  exit(0);
}


include("pkg-lib-deb.inc");
include("revisions-lib.inc");

release = get_kb_item("ssh/login/release");

if(release == NULL){
  exit(0);
}

if(release == "UBUNTU6.06 LTS")
{

  if(isdpkgvuln(pkg:"firefox-dbg", ver:"1.5.dfsg+1.5.0.15~prepatch080614h-0ubuntu1", rls:"UBUNTU6.06 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"firefox-dev", ver:"1.5.dfsg+1.5.0.15~prepatch080614h-0ubuntu1", rls:"UBUNTU6.06 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"firefox-gnome-support", ver:"1.5.dfsg+1.5.0.15~prepatch080614h-0ubuntu1", rls:"UBUNTU6.06 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"firefox", ver:"1.5.dfsg+1.5.0.15~prepatch080614h-0ubuntu1", rls:"UBUNTU6.06 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"libnspr-dev", ver:"1.firefox1.5.dfsg+1.5.0.15~prepatch080614h-0ubuntu1", rls:"UBUNTU6.06 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"libnspr4", ver:"1.firefox1.5.dfsg+1.5.0.15~prepatch080614h-0ubuntu1", rls:"UBUNTU6.06 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"libnss-dev", ver:"1.firefox1.5.dfsg+1.5.0.15~prepatch080614h-0ubuntu1", rls:"UBUNTU6.06 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"libnss3", ver:"1.firefox1.5.dfsg+1.5.0.15~prepatch080614h-0ubuntu1", rls:"UBUNTU6.06 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"firefox-dom-inspector", ver:"1.5.dfsg+1.5.0.15~prepatch080614h-0ubuntu1", rls:"UBUNTU6.06 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"mozilla-firefox", ver:"1.5.dfsg+1.5.0.15~prepatch080614h-0ubuntu1", rls:"UBUNTU6.06 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"mozilla-firefox-dev", ver:"1.5.dfsg+1.5.0.15~prepatch080614h-0ubuntu1", rls:"UBUNTU6.06 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}


if(release == "UBUNTU8.10")
{

  if(isdpkgvuln(pkg:"abrowser", ver:"3.0-branding_3.0.4+nobinonly-0ubuntu0.8.10.1", rls:"UBUNTU8.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"firefox", ver:"3.0-branding_3.0.4+nobinonly-0ubuntu0.8.10.1", rls:"UBUNTU8.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"firefox", ver:"3.0-dev_3.0.4+nobinonly-0ubuntu0.8.10.1", rls:"UBUNTU8.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"firefox", ver:"3.0-gnome-support_3.0.4+nobinonly-0ubuntu0.8.10.1", rls:"UBUNTU8.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"firefox", ver:"3.0_3.0.4+nobinonly-0ubuntu0.8.10.1", rls:"UBUNTU8.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"xulrunner", ver:"1.9-dev_1.9.0.4+nobinonly-0ubuntu0.8.10.1", rls:"UBUNTU8.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"xulrunner", ver:"1.9-gnome-support_1.9.0.4+nobinonly-0ubuntu0.8.10.1", rls:"UBUNTU8.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"xulrunner", ver:"1.9_1.9.0.4+nobinonly-0ubuntu0.8.10.1", rls:"UBUNTU8.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"xulrunner-dev", ver:"1.9.0.4+nobinonly-0ubuntu0.8.10.1", rls:"UBUNTU8.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"abrowser", ver:"3.0.4+nobinonly-0ubuntu0.8.10.1", rls:"UBUNTU8.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"firefox-dev", ver:"3.0.4+nobinonly-0ubuntu0.8.10.1", rls:"UBUNTU8.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"firefox-gnome-support", ver:"3.0.4+nobinonly-0ubuntu0.8.10.1", rls:"UBUNTU8.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"firefox-granparadiso-dev", ver:"3.0.4+nobinonly-0ubuntu0.8.10.1", rls:"UBUNTU8.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"firefox-trunk-dev", ver:"3.0.4+nobinonly-0ubuntu0.8.10.1", rls:"UBUNTU8.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"firefox", ver:"3.0.4+nobinonly-0ubuntu0.8.10.1", rls:"UBUNTU8.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"firefox", ver:"3.0-dom-inspector_3.0.4+nobinonly-0ubuntu0.8.10.1", rls:"UBUNTU8.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"firefox", ver:"3.0-venkman_3.0.4+nobinonly-0ubuntu0.8.10.1", rls:"UBUNTU8.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"firefox-dom-inspector", ver:"3.0.4+nobinonly-0ubuntu0.8.10.1", rls:"UBUNTU8.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"firefox-granparadiso-dom-inspector", ver:"3.0.4+nobinonly-0ubuntu0.8.10.1", rls:"UBUNTU8.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"firefox-granparadiso-gnome-support", ver:"3.0.4+nobinonly-0ubuntu0.8.10.1", rls:"UBUNTU8.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"firefox-granparadiso", ver:"3.0.4+nobinonly-0ubuntu0.8.10.1", rls:"UBUNTU8.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"firefox-libthai", ver:"3.0.4+nobinonly-0ubuntu0.8.10.1", rls:"UBUNTU8.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"firefox-trunk-dom-inspector", ver:"3.0.4+nobinonly-0ubuntu0.8.10.1", rls:"UBUNTU8.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"firefox-trunk-gnome-support", ver:"3.0.4+nobinonly-0ubuntu0.8.10.1", rls:"UBUNTU8.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"firefox-trunk-venkman", ver:"3.0.4+nobinonly-0ubuntu0.8.10.1", rls:"UBUNTU8.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"firefox-trunk", ver:"3.0.4+nobinonly-0ubuntu0.8.10.1", rls:"UBUNTU8.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"xulrunner", ver:"1.9-dom-inspector_1.9.0.4+nobinonly-0ubuntu0.8.10.1", rls:"UBUNTU8.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"xulrunner", ver:"1.9-venkman_1.9.0.4+nobinonly-0ubuntu0.8.10.1", rls:"UBUNTU8.10"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}


if(release == "UBUNTU8.04 LTS")
{

  if(isdpkgvuln(pkg:"firefox", ver:"3.0-dev_3.0.4+nobinonly-0ubuntu0.8.04.1", rls:"UBUNTU8.04 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"firefox", ver:"3.0-gnome-support_3.0.4+nobinonly-0ubuntu0.8.04.1", rls:"UBUNTU8.04 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"firefox", ver:"3.0_3.0.4+nobinonly-0ubuntu0.8.04.1", rls:"UBUNTU8.04 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"xulrunner", ver:"1.9-dev_1.9.0.4+nobinonly-0ubuntu0.8.04.1", rls:"UBUNTU8.04 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"xulrunner", ver:"1.9-gnome-support_1.9.0.4+nobinonly-0ubuntu0.8.04.1", rls:"UBUNTU8.04 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"xulrunner", ver:"1.9_1.9.0.4+nobinonly-0ubuntu0.8.04.1", rls:"UBUNTU8.04 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"firefox-2-dbg", ver:"2.0.0.18+nobinonly-0ubuntu0.8.04.1", rls:"UBUNTU8.04 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"firefox-2-dev", ver:"2.0.0.18+nobinonly-0ubuntu0.8.04.1", rls:"UBUNTU8.04 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"firefox-2-gnome-support", ver:"2.0.0.18+nobinonly-0ubuntu0.8.04.1", rls:"UBUNTU8.04 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"firefox-2-libthai", ver:"2.0.0.18+nobinonly-0ubuntu0.8.04.1", rls:"UBUNTU8.04 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"firefox-2", ver:"2.0.0.18+nobinonly-0ubuntu0.8.04.1", rls:"UBUNTU8.04 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"firefox-dev", ver:"3.0.4+nobinonly-0ubuntu0.8.04.1", rls:"UBUNTU8.04 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"firefox-gnome-support", ver:"3.0.4+nobinonly-0ubuntu0.8.04.1", rls:"UBUNTU8.04 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"firefox-granparadiso-dev", ver:"3.0.4+nobinonly-0ubuntu0.8.04.1", rls:"UBUNTU8.04 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"firefox-trunk-dev", ver:"3.0.4+nobinonly-0ubuntu0.8.04.1", rls:"UBUNTU8.04 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"firefox", ver:"3.0.4+nobinonly-0ubuntu0.8.04.1", rls:"UBUNTU8.04 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"firefox", ver:"3.0-dom-inspector_3.0.4+nobinonly-0ubuntu0.8.04.1", rls:"UBUNTU8.04 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"firefox", ver:"3.0-venkman_3.0.4+nobinonly-0ubuntu0.8.04.1", rls:"UBUNTU8.04 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"firefox-dom-inspector", ver:"3.0.4+nobinonly-0ubuntu0.8.04.1", rls:"UBUNTU8.04 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"firefox-granparadiso-dom-inspector", ver:"3.0.4+nobinonly-0ubuntu0.8.04.1", rls:"UBUNTU8.04 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"firefox-granparadiso-gnome-support", ver:"3.0.4+nobinonly-0ubuntu0.8.04.1", rls:"UBUNTU8.04 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"firefox-granparadiso", ver:"3.0.4+nobinonly-0ubuntu0.8.04.1", rls:"UBUNTU8.04 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"firefox-libthai", ver:"3.0.4+nobinonly-0ubuntu0.8.04.1", rls:"UBUNTU8.04 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"firefox-trunk-dom-inspector", ver:"3.0.4+nobinonly-0ubuntu0.8.04.1", rls:"UBUNTU8.04 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"firefox-trunk-gnome-support", ver:"3.0.4+nobinonly-0ubuntu0.8.04.1", rls:"UBUNTU8.04 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"firefox-trunk-venkman", ver:"3.0.4+nobinonly-0ubuntu0.8.04.1", rls:"UBUNTU8.04 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"firefox-trunk", ver:"3.0.4+nobinonly-0ubuntu0.8.04.1", rls:"UBUNTU8.04 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"firefox-2-dom-inspector", ver:"2.0.0.18+nobinonly-0ubuntu0.8.04.1", rls:"UBUNTU8.04 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"xulrunner", ver:"1.9-dom-inspector_1.9.0.4+nobinonly-0ubuntu0.8.04.1", rls:"UBUNTU8.04 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"xulrunner", ver:"1.9-venkman_1.9.0.4+nobinonly-0ubuntu0.8.04.1", rls:"UBUNTU8.04 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}


if(release == "UBUNTU7.10")
{

  if(isdpkgvuln(pkg:"firefox-dbg", ver:"2.0.0.18+nobinonly-0ubuntu0.7.10", rls:"UBUNTU7.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"firefox-dev", ver:"2.0.0.18+nobinonly-0ubuntu0.7.10", rls:"UBUNTU7.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"firefox-gnome-support", ver:"2.0.0.18+nobinonly-0ubuntu0.7.10", rls:"UBUNTU7.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"firefox-libthai", ver:"2.0.0.18+nobinonly-0ubuntu0.7.10", rls:"UBUNTU7.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"firefox", ver:"2.0.0.18+nobinonly-0ubuntu0.7.10", rls:"UBUNTU7.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"firefox-dom-inspector", ver:"2.0.0.18+nobinonly-0ubuntu0.7.10", rls:"UBUNTU7.10"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}