###############################################################################
# OpenVAS Vulnerability Test
#
# Ubuntu Update for ruby1.9 vulnerability USN-691-1
#
# Authors:
# System Generated Check
#
# Copyright:
# Copyright (c) 2009 Intevation GmbH, http://www.intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(840350);
  script_version("$Revision: 1.0 $");
  script_xref(name: "USN", value: "691-1");
  script_cve_id("CVE-2008-3443", "CVE-2008-3790");
  script_name( "Ubuntu Update for ruby1.9 vulnerability USN-691-1");
  desc = "

  Vulnerability Insight:

  Laurent Gaffie discovered that Ruby did not properly check for memory
  allocation failures. If a user or automated system were tricked into
  running a malicious script, an attacker could cause a denial of
  service. (CVE-2008-3443)
  
  This update also fixes a regression in the upstream patch previously
  applied to fix CVE-2008-3790. The regression would cause parsing of
  some XML documents to fail.

  Affected Software/OS:
  ruby1.9 vulnerability on Ubuntu 8.10

  Fix: Please Install the Updated Packages.

  References:
  https://lists.ubuntu.com/archives/ubuntu-security-announce/2008-December/000802.html

  Risk factor: High";

  script_description(desc);
  script_summary("Check for the Version of ruby1.9 vulnerability");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (C) 2009 Intevation GmbH");
  script_family("Ubuntu Local Security Checks");
  script_dependencies("gather-package-list.nasl");
  script_require_keys("ssh/login/release");
  exit(0);
}


include("pkg-lib-deb.inc");
include("revisions-lib.inc");

release = get_kb_item("ssh/login/release");

if(release == NULL){
  exit(0);
}

if(release == "UBUNTU8.10")
{

  if(isdpkgvuln(pkg:"libruby1.9-dbg", ver:"1.9.0.2-7ubuntu1.1", rls:"UBUNTU8.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"libruby1.9", ver:"1.9.0.2-7ubuntu1.1", rls:"UBUNTU8.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"ruby1.9-dev", ver:"1.9.0.2-7ubuntu1.1", rls:"UBUNTU8.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"ruby1.9", ver:"1.9.0.2-7ubuntu1.1", rls:"UBUNTU8.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"libdbm-ruby1.9", ver:"1.9.0.2-7ubuntu1.1", rls:"UBUNTU8.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"libgdbm-ruby1.9", ver:"1.9.0.2-7ubuntu1.1", rls:"UBUNTU8.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"libopenssl-ruby1.9", ver:"1.9.0.2-7ubuntu1.1", rls:"UBUNTU8.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"libreadline-ruby1.9", ver:"1.9.0.2-7ubuntu1.1", rls:"UBUNTU8.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"libtcltk-ruby1.9", ver:"1.9.0.2-7ubuntu1.1", rls:"UBUNTU8.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"irb1.9", ver:"1.9.0.2-7ubuntu1.1", rls:"UBUNTU8.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"rdoc1.9", ver:"1.9.0.2-7ubuntu1.1", rls:"UBUNTU8.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"ri1.9", ver:"1.9.0.2-7ubuntu1.1", rls:"UBUNTU8.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"ruby1.9-elisp", ver:"1.9.0.2-7ubuntu1.1", rls:"UBUNTU8.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"ruby1.9-examples", ver:"1.9.0.2-7ubuntu1.1", rls:"UBUNTU8.10"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}