###############################################################################
# OpenVAS Vulnerability Test
#
# Ubuntu Update for gzip vulnerabilities USN-889-1
#
# Authors:
# System Generated Check
#
# Copyright:
# Copyright (c) 2010 Greenbone Networks GmbH, http://www.greenbone.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(840374);
  script_version("$Revision: 6485 $: 1.0");
  script_xref(name: "USN", value: "889-1");
  script_cve_id("CVE-2009-2624", "CVE-2010-0001");
  script_name("Ubuntu Update for gzip vulnerabilities USN-889-1");
  desc = "

  Vulnerability Insight:

  It was discovered that gzip incorrectly handled certain malformed
  compressed files. If a user or automated system were tricked into opening a
  specially crafted gzip file, an attacker could cause gzip to crash or
  possibly execute arbitrary code with the privileges of the user invoking
  the program. (CVE-2009-2624)
  
  Aki Helin discovered that gzip incorrectly handled certain malformed
  files compressed with the Lempel&#8211;Ziv&#8211;Welch (LZW) algorithm. If a user or
  automated system were tricked into opening a specially crafted gzip file,
  an attacker could cause gzip to crash or possibly execute arbitrary code
  with the privileges of the user invoking the program. (CVE-2010-0001)

  Affected Software/OS:
  gzip vulnerabilities on Ubuntu 6.06 LTS ,
  Ubuntu 8.04 LTS ,
  Ubuntu 8.10 ,
  Ubuntu 9.04 ,
  Ubuntu 9.10

  Fix: Please Install the Updated Packages.

  References:
  https://lists.ubuntu.com/archives/ubuntu-security-announce/2010-January/001032.html

  Risk factor: High";

  script_description(desc);
  script_summary("Check for the Version of gzip vulnerabilities");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (c) 2010 Greenbone Networks GmbH");
  script_family("Ubuntu Local Security Checks");
  script_dependencies("gather-package-list.nasl");
  script_require_keys("ssh/login/release");
  exit(0);
}


include("pkg-lib-deb.inc");
include("revisions-lib.inc");

release = get_kb_item("ssh/login/release");

if(release == NULL){
  exit(0);
}

if(release == "UBUNTU9.04")
{

  if(isdpkgvuln(pkg:"gzip", ver:"1.3.12-6ubuntu2.9.04.1", rls:"UBUNTU9.04"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}


if(release == "UBUNTU6.06 LTS")
{

  if(isdpkgvuln(pkg:"gzip", ver:"1.3.5-12ubuntu0.3", rls:"UBUNTU6.06 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}


if(release == "UBUNTU8.10")
{

  if(isdpkgvuln(pkg:"gzip", ver:"1.3.12-6ubuntu2.8.10.1", rls:"UBUNTU8.10"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}


if(release == "UBUNTU8.04 LTS")
{

  if(isdpkgvuln(pkg:"gzip", ver:"1.3.12-3.2ubuntu0.1", rls:"UBUNTU8.04 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}


if(release == "UBUNTU9.10")
{

  if(isdpkgvuln(pkg:"gzip", ver:"1.3.12-8ubuntu1.1", rls:"UBUNTU9.10"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}