###############################################################################
# OpenVAS Vulnerability Test
# $Id: gb_varnish_logs_escape_sequence_inj_vuln.nasl 6807 2010-01-27 16:30:29Z jan $
#
# Varnish Log Escape Sequence Injection  Vulnerability
#
# Authors:
# Antu Sanadi <santu@secpod.com>
#
# Copyright:
# Copyright (c) 2010 Greenbone Networks GmbH, http://www.greenbone.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(800447);
  script_version("$Revision: 6582 $: 1.0");
  script_cve_id("CVE-2009-4488");
  script_bugtraq_id(37713);
  script_name("Varnish Log Escape Sequence Injection Vulnerability");
  desc = "
  Overview: This host is installed with Varnish and is prone to Log Escape
  Sequence Injection Vulnerability.

  Vulnerability Insight:
  The flaw exists when the Web Server is executed in foreground in a pty or
  when the logfiles are viewed with tools like 'cat' or 'tail' injected control
  characters reach the terminal and are executed.

  Impact:
  Successful exploitation will let the attacker execute arbitrary commands in
  a terminal.

  Impact level: Application

  Affected Software/OS:
  Varnish version 2.0.6 and prior.

  Fix:
  No solution or patch is available as on 27th January, 2010. Information
  regarding this issue will be updated once the solution details are available.
  For updates refer, http://varnish.projects.linpro.no/wiki/WikiStart

  References:
  http://www.ush.it/team/ush/hack_httpd_escape/adv.txt
  http://www.securityfocus.com/archive/1/archive/1/508830/100/0/threaded

  CVSS Score:
    CVSS Base Score       : 5.0 (AV:N/AC:L/Au:NR/C:P/I:N/A:N)
    CVSS Temporal Score   : 4.5
  Risk factor : Medium";

  script_description(desc);
  script_summary("Check for the version of Varnish");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (c) 2010 Greenbone Networks GmbH");
  script_family("Web Servers");
  script_dependencies("find_service.nes", "gb_varnish_detect.nasl");
  script_require_ports("Services/www", 80);
  script_require_keys("Varnish/Ver");
  exit(0);
}


include("http_func.inc");
include("version_func.inc");

port = get_http_port(default:80);
if(!get_port_state(port)){
  exit(0);
}

varVer = get_kb_item("Varnish/Ver");
if(!varVer){
  exit(0);
}

banner = get_http_banner(port:port);
if("X-Varnish" >< banner)
{
  if(version_is_less_equal(version:varVer, test_version:"2.0.6")){
    security_warning(0);
  }
}
