###############################################################################
# OpenVAS Vulnerability Test
# $Id: gb_virusblokada_av_dos_vuln.nasl 728 2008-12-22 12:30:29Z dec $
#
# VirusBlokAda Personal AV Denial of Service Vulnerability
#
# Authors:
# Sujit Ghosal <sghosal@secpod.com>
#
# Copyright:
# Copyright (c) 2008 Intevation GmbH, http://www.intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(800213);
  script_version("$Revision: 1.0 $");
  script_cve_id("CVE-2008-5667");
  script_bugtraq_id(31560);
  script_name("VirusBlokAda Personal AV Denial of Service Vulnerability");
  desc = "

  Overview: This host is installed with VirusBlokAda and is prone to Denial
  of Service vulnerability.

  Vulnerability Insight:
  Scanning archive files that are crafted maliciously causes application crash.

  Impact:
  Successful exploitation could allow attacker to execute arbitrary codes
  through compressed rar achive and can cause memory corruption or service
  crash.

  Affected Software/OS:
  VirusBlokAda version 3.12.8.5 or prior.

  Fix: No solution or patch is available as on 22nd December, 2008. Information
  regarding this issue will be updated once the solution details are available.
  For further updates refer, http://www.anti-virus.by/en/personal.html

  References:
  http://www.milw0rm.com/exploits/6658
  http://web.nvd.nist.gov/view/vuln/detail?vulnId=CVE-2008-5667

  CVSS Score:
    CVSS Base Score     : 5.0 (AV:N/AC:L/Au:NR/C:N/I:N/A:P)
    CVSS Temporal Score : 4.5
  Risk factor: Medium";

  script_description(desc);
  script_summary("Check for the version of VirusBlokAda");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (C) 2008 Intevation GmbH");
  script_family("Denial of Service");
  script_dependencies("secpod_reg_enum.nasl");
  script_require_keys("SMB/WindowsVersion");
  script_require_ports(139, 445);
  exit(0);
}


include("smb_nt.inc");
include("version_func.inc");
include("secpod_smb_func.inc");

if(!get_kb_item("SMB/WindowsVersion")){
  exit(0);
}

vbacheck = registry_key_exists(key:"SOFTWARE\Vba32\Loader");
if(!vbacheck){
  exit(0);
}

key = "SOFTWARE\Microsoft\Windows\CurrentVersion\Uninstall\";
foreach item (registry_enum_keys(key:key))
{
  vba = registry_get_sz(key:key + item, item:"DisplayName");
  if("Vba32" >< vba)
  {
    vbaVer = registry_get_sz(key:key + item, item:"DisplayVersion");
    if(vbaVer != NULL)
    {
      # Grep for version 3.12.8.5 or prior
      if(version_is_less_equal(version:vbaVer, test_version:"3.12.8.5")){
        security_warning(0);
      }
    }
    exit(0);
  }
}
