###############################################################################
# OpenVAS Vulnerability Test
# $Id: gb_vlc_media_player_ass_bof_vuln_win.nasl 6945 2010-01-23 12:52:23Z jan $
#
# VLC Media Player ASS File Buffer Overflow Vulnerability (Win)
#
# Authors:
# Antu Sanadi <santu@secpod.com>
#
# Copyright:
# Copyright (c) 2010 Greenbone Networks GmbH, http://www.greenbone.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(800444);
  script_version("$Revision: 6582 $: 1.0");
  script_cve_id("CVE-2010-0364");
  script_bugtraq_id(37832);
  script_name("VLC Media Player ASS File Buffer Overflow Vulnerability (Win)");
  desc = "
  Overview: This host is installed with VLC Media Player and is prone to
  Stack-Based Buffer Overflow Vulnerability.

  Vulnerability Insight:
  The flaw exists due to stack-based buffer overflow error in Aegisub Advanced
  SubStation ('.ass') file handler that fails to perform adequate boundary checks on
  user-supplied input.

  Impact:
  Successful exploitation allows attackers to execute arbitrary code, and can
  casue application crash.

  Impact Level: Application

  Affected Software/OS:
  VLC Media Player version 0.8.6 on Windows.

  Fix:
  No solution/patch is available as on 23rd January, 2010. Information
  regarding this issue will updated once the solution details are available.
  For updates refer, http://www.videolan.org/vlc/

  References:
  http://xforce.iss.net/xforce/xfdb/55717
  http://www.exploit-db.com/exploits/11174

  CVSS Score:
    CVSS Base Score      : 9.3 (AV:N/AC:M/Au:NR/C:C/I:C/A:C)
    CVSS Temporal Score  : 8.4
  Risk factor : Critical";

  script_description(desc);
  script_summary("Check for the version of VLC Media Player");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (c) 2010 Greenbone Networks GmbH");
  script_family("Buffer overflow");
  script_dependencies("secpod_vlc_media_player_detect_win.nasl");
  script_require_keys("VLCPlayer/Win/Ver");
  exit(0);
}


include("version_func.inc");

vlcVer = get_kb_item("VLCPlayer/Win/Ver");
if(!isnull(vlcVer) &&  vlcVer =~ "^0\.8\.6.*"){
  security_hole(0);
}
