###############################################################################
# OpenVAS Vulnerability Test
# $Id: gb_vlc_media_player_intgr_bof_vuln_lin.nasl 585 2008-12-04 15:15:20Z dec $
#
# VLC Media Player Buffer Overflow Vulnerability (Linux)
#
# Authors:
# Chandan S <schandan@secpod.com>
#
# Copyright:
# Copyright (c) 2008 Intevation GmbH, http://www.intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(800077);
  script_version("$Revision: 1.0 $");
  script_cve_id("CVE-2008-5276");
  script_bugtraq_id(32545);
  script_name("VLC Media Player Buffer Overflow Vulnerability (Linux)");
  desc = "

  Overview: This host is installed with VLC Media Player and is prone to
  Buffer Overflow Vulnerability.

  Vulnerability Insight:
  The flaw is caused due to a boundary error while parsing ReadRealIndex
  function in real.c in the Real demuxer plugin.

  Impact: Successful exploitation allows attackers to execute arbitrary
  code by tricking a user into opening a specially crafted .rm file to
  crash an affected application.

  Impact Level: Application

  Affected Software/OS:
  VLC media player 0.9.0 through 0.9.7 on Linux (Any).

  Fix: Upgrade to VLC media player 0.9.8
  http://www.videolan.org/vlc/

  References:
  http://www.videolan.org/security/sa0811.html
  http://www.vupen.com/english/advisories/2008/3287
  http://www.trapkit.de/advisories/TKADV2008-013.txt

  CVSS Score:
    CVSS Base Score     : 9.3 (AV:N/AC:M/Au:NR/C:C/I:C/A:C)
    CVSS Temporal Score : 6.9
  Risk factor: High";

  script_description(desc);
  script_summary("Check for the Version of VLC Media Player");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (C) 2008 Intevation GmbH");
  script_family("Denial of Service");
  exit(0);
}


include("ssh_func.inc");
include("version_func.inc");

sock = ssh_login_or_reuse_connection();
if(!sock){
  exit(0);
}

vlcBinPath = find_bin(prog_name:"vlc", sock:sock);
foreach binPath (vlcBinPath)
{
  vlcVer = get_bin_version(full_prog_name:chomp(binPath), version_argv:"--version",
                           ver_pattern:"ersion ([0-9.]+[a-z]?)", sock:sock);
  if(vlcVer[1] != NULL)
  {
    # VLC Media Player Version 0.9.0 to 0.9.7
    if(version_in_range(version:vlcVer[1], test_version:"0.9.0",
                        test_version2:"0.9.7")){
      security_hole(0);
    }
    ssh_close_connection();
    exit(0);
  }
}
ssh_close_connection();
