###############################################################################
# OpenVAS Vulnerability Test
# $Id: gb_vmware_prdts_inguest_prv_esc_vuln_win.nasl 458 2008-12-01 12:52:40Z dec $
#
# VMware Products Trap Flag In-Guest Privilege Escalation Vulnerability (Win)
#
# Authors:
# Chandan S <schandan@secpod.com>
#
# Copyright:
# Copyright (c) 2008 Intevation GmbH, http://www.intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(800071);
  script_version("$Revision: 1.1 $");
  script_cve_id("CVE-2008-4915", "CVE-2008-4917");
  script_bugtraq_id(32168);
  script_name("VMware Products Trap Flag In-Guest Privilege Escalation Vulnerability (Win)");
  desc = "

  Overview : The host is installed with VMWare product(s) that are vulnerable
  to privilege escalation vulnerability.

  Vulnerability Insight:
  The issue is caused due to an error in the CPU hardware emulation while
  handling the trap flag.

  Impact : Successful exploitation allow attackers to execute arbitrary code
  on the affected system and users could bypass certain security restrictions
  or can gain escalated privileges.

  Impact Level : System

  Affected Software/OS:
  VMware Server 1.x - 1.0.7 on Windows
  VMware ACE 1.x - 1.0.7 and 2.x - 2.0.5 on Windows
  VMware Player 1.x - 1.0.8 and 2.x - 2.0.5 on Windows
  VMware Workstation 6.0.5 and earlier on all Windows

  Fix : Upgrade VMware latest versions,
  www.vmware.com/download/ws/
  www.vmware.com/download/ace/
  www.vmware.com/download/player/
  www.vmware.com/download/server/

  References:
  http://www.frsirt.com/english/advisories/2008/3052
  http://www.vmware.com/security/advisories/VMSA-2008-0018.html

  CVSS Score:
    CVSS Base Score     : 6.9 (AV:L/AC:M/Au:NR/C:C/I:C/A:C)
    CVSS Temporal Score : 5.1
  Risk factor : Medium";

  script_description(desc);
  script_summary("Check for the version of VMware Products");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (C) 2008 Intevation GmbH");
  script_family("General");
  script_dependencies("gb_vmware_prdts_detect_win.nasl");
  exit(0);
}


include("version_func.inc");

if(!get_kb_item("VMware/Win/Installed")){
  exit(0);
}

# VMware Server
vmserverVer = get_kb_item("VMware/Server/Win/Ver");
if(vmserverVer)
{
  if(version_is_less_equal(version:vmserverVer, test_version:"1.0.7")){
    security_hole(0);
  }
  exit(0);
}

# VMware Player
vmplayerVer = get_kb_item("VMware/Player/Win/Ver");
if(vmplayerVer)
{
  if(version_is_less_equal(version:vmplayerVer, test_version:"1.0.8"))
  {
    security_hole(0);
    exit(0);
  }
  else if(version_in_range(version:vmplayerVer, test_version:"2.0",
          test_version2:"2.0.5")){
    security_hole(0);
  }
  exit(0);
}

# VMware Workstation
vmworkstnVer = get_kb_item("VMware/Workstation/Win/Ver");
if(vmworkstnVer)
{
  if(version_in_range(version:vmworkstnVer, test_version:"5.0",
                      test_version2:"5.5.8"))
  {
    security_hole(0);
    exit(0);
  }
  else if(version_in_range(version:vmworkstnVer, test_version:"6.0",
          test_version2:"6.0.5")){
    security_hole(0);
  }
  exit(0);
}

# VMware ACE
vmaceVer = get_kb_item("VMware/ACE/Win/Ver");
if(!vmaceVer){
  vmaceVer = get_kb_item("VMware/ACE\Dormant/Win/Ver");
}

if(vmaceVer)
{
  if(version_is_less_equal(version:vmaceVer, test_version:"1.0.7"))
  {
    security_hole(0);
    exit(0);
  }
  else if(version_in_range(version:vmaceVer, test_version:"2.0",
          test_version2:"2.0.5")){
    security_hole(0);
  }
}
