###############################################################################
# OpenVAS Vulnerability Test
# $Id: gb_vmware_serv_dir_trav_vuln_nov09_lin.nasl 5590 2009-11-04 17:45:21Z nov $
#
# VMware Server Directory Traversal Vulnerability - Nov09 (Linux)
#
# Authors:
# Sharath S <sharaths@secpod.com>
#
# Copyright:
# Copyright (c) 2009 Intevation GmbH, http://www.intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(801144);
  script_version("$Revision: 1.0 $");
  script_cve_id("CVE-2009-3733");
  script_bugtraq_id(36842);
  script_name("VMware Serve Directory Traversal Vulnerability - Nov09 (Linux)");
  desc = "
  Overview: The host is installed with VMWare product(s) and is prone to multiple
  vulnerability.

  Vulnerability Insight:
  An error exists while handling certain requests can be exploited to download
  arbitrary files from the host system via directory traversal attacks.

  Impact:
  Successful exploitation will let the remote/local attacker to disclose
  sensitive information.

  Impact Level: System

  Affected Software/OS:
  VMware Server version 2.0.x prior to 2.0.2 Build 203138,
  VMware Server version 1.0.x prior to 1.0.10 Build 203137 on Linux.

  Fix: Upgrade your VMWares according to the below link,
  http://www.vmware.com/security/advisories/VMSA-2009-0015.html

  References:
  http://secunia.com/advisories/37186
  http://www.vupen.com/english/advisories/2009/3062
  http://securitytracker.com/alerts/2009/Oct/1023088.html
  http://lists.vmware.com/pipermail/security-announce/2009/000069.html

  CVSS Score:
    CVSS Base Score     : 4.3 (AV:N/AC:M/Au:NR/C:P/I:N/A:N)
    CVSS Temporal Score : 3.4
  Risk factor: Medium";

  script_description(desc);
  script_summary("Check for the version of VMware Server");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (C) 2009 Intevation GmbH");
  script_family("General");
  script_dependencies("gb_vmware_prdts_detect_lin.nasl","vmware_36842_remote.nasl");
  script_require_keys("VMware/Linux/Installed", "VMware/Server/Linux/Ver");
  exit(0);
}


include("version_func.inc");

if(!get_kb_item("VMware/Linux/Installed")){
  exit(0);
}

if(get_kb_item("VMware/Server/Linux/36842")){ # vulnerabillity already discovered by remote check. So exit to not report it twice.
  exit(0);
}

# Check for VMware Server
vmserverVer = get_kb_item("VMware/Server/Linux/Ver");
if(vmserverVer)
{
  # Check for version 1.0 < 1.0.10 (1.0.10 Build 203137) or 2.0 < 2.0.2 (2.0.2 Build 203138)
  if(version_in_range(version:vmserverVer, test_version:"1.0",
                                          test_version2:"1.0.9")||
     version_in_range(version:vmserverVer, test_version:"2.0",
                                          test_version2:"2.0.1")){
    security_warning(0);
  }
}
