###############################################################################
# OpenVAS Vulnerability Test
# $Id: gb_webcalendar_mult_css_n_csrf_vuln.nasl 7279 2010-02-16 11:43:17Z feb $
#
# WebCalendar Multiple CSS and CSRF Vulnerabilities
#
# Authors:
# Antu Sanadi <santu@secpod.com>
#
# Copyright:
# Copyright (c) 2010 Greenbone Networks GmbH, http://www.greenbone.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(800472);
  script_version("$Revision: 6788 $: 1.0");
  script_cve_id("CVE-2010-0636", "CVE-2010-0637", "CVE-2010-0638");
  script_bugtraq_id(38053);
  script_name("WebCalendar Multiple CSS and CSRF Vulnerabilities");
  desc = "
  Overview: The host is running WebCalendar and is prone to multiple CSS and
  CSRF Vulnerabilities.

  Vulnerability Insight:
  - Input passed to the 'tab' parameter in 'users.php' is not properly
    sanitised before being returned to the user.
  - Input appended to the URL after 'day.php', 'month.php', and 'week.php'
    is not properly sanitised before being returned to the user.
  - The application allows users to perform certain actions via HTTP requests
    without performing any validity checks to verify the requests. This can be
    exploited to delete an event, ban an IP address from posting, or change the
    administrative password if a logged-in administrative user visits a malicious
    web site.

  Impact:
  Successful exploitation could allow attackers to conduct cross-site scripting
  and request forgery attacks.

  Impact Level: Application

  Affected Software/OS:
  WebCalendar version 1.2.0 and prior.

  Fix: No solution or patch is available as on 16th February, 2010. Information
  regarding this issue will be updated once the solution details are available.
  For Updates Refer, http://www.k5n.us/webcalendar.php?topic=Download

  References:
  http://secunia.com/advisories/38222
  http://holisticinfosec.org/content/view/133/45/

  CVSS Score:
    CVSS Base Score      : 6.8 (AV:N/AC:M/Au:NR/C:P/I:P/A:P)
    CVSS Temporal Score  : 5.8
  Risk factor: High";

  script_description(desc);
  script_copyright("Copyright (c) 2010 Greenbone Networks GmbH");
  script_summary("Check the version of WebCalendar");
  script_category(ACT_GATHER_INFO);
  script_family("Web application abuses");
  script_dependencies("webcalendar_detect.nasl");
  script_require_ports("Services/www", 80);
  exit(0);
}


include("http_func.inc");
include("version_func.inc");

wcport = get_http_port(default:80);
if(!wcport){
  exit(0);
}

wcver = get_kb_item("www/" + wcport + "/webcalendar");
if(isnull(wcver)){
  exit(0);
}

wcver = eregmatch(pattern:"^(.+) under (/.*)$", string:wcver);
if(!isnull(wcver[1]))
{
  # check  WebCalendar version 1.2.0
  if(version_is_less_equal(version:wcver[1], test_version:"1.2.0")){
    security_hole(wcport);
  }
}
