###############################################################################
# OpenVAS Vulnerability Test
# $dI: gb_webcamxp_dir_trav_vuln.nasl 821 2009-01-09 19:30:24Z jan $
#
# webcamXP URL Directory Traversal Vulnerability
#
# Authors:
# Sujit Ghosal <sghosal@secpod.com>
#
# Copyright:
# Copyright (c) 2009 Intevation GmbH, http://www.intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(800222);
  script_version("$Revision: 1.0 $");
  script_cve_id("CVE-2008-5862");
  script_bugtraq_id(32928);
  script_name("webcamXP URL Directory Traversal Vulnerability");
  desc = "

  Overview: This host is installed with webcamXP and is prone to Directory
  Traversal Vulnerability.

  Vulnerability Insight:
  The flaw is due to improper handling of URL-encoded forward-slashes i.e, ../
  which causes execution of malicious URI into the context of the application.

  Impact:
  Successful exploitation will let the attacker to execute malicious URL into
  the web browser in the attacking machine and can get sensitive information
  about the application or about the remote system.

  Impact Level: System/Application

  Affected Software/OS:
  Darkwet, webcamXP version 5.3.2.410 and prior on Windows.

  Fix: No solution or patch is available as on 09th January 2009. Information
  regarding this issue will be updated once the solution details are available.
  For updates refer, http://www.webcamxp.com

  References:
  http://secunia.com/advisories/33257
  http://www.milw0rm.com/exploits/7521

  CVSS Score:
    CVSS Base Score     : 5.0 (AV:N/AC:L/Au:NR/C:P/I:N/A:N)
    CVSS Temporal Score : 4.5
  Risk factor: Medium";

  script_description(desc);
  script_summary("Check for the Version of webcamXP");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (C) 2009 Intevation GmbH");
  script_family("Web application abuses");
  script_dependencies("gb_webcamxp_detect.nasl");
  script_require_keys("WebcamXP/Version");
  exit(0);
}


include("version_func.inc");

wcVer = get_kb_item("WebcamXP/Version");
if(!wcVer){
  exit(0);
}

#Check for webcamXP version 5.3.2.410 or prior
if(version_is_less_equal(version:wcVer, test_version:"5.3.2.410")){
  security_warning(0);
}
