###############################################################################
# OpenVAS Vulnerability Test
# $Id: gb_wincomlpd_total_mult_vuln.nasl 516 2008-11-21 12:01:42Z nov $
#
# WinComLPD Total Multiple Vulnerabilities
#
# Authors:
# Chandan S <schandan@secpod.com>
#
# Copyright:
# Copyright (c) 2008 Intevation GmbH, http://www.intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(800063);
  script_version("$Revision: 1.0 $");
  script_cve_id("CVE-2008-5158", "CVE-2008-5159", "CVE-2008-5176");
  script_bugtraq_id(27614);
  script_name("WinComLPD Total Multiple Vulnerabilities");
  desc = "

  Overview: This host is installed with WinComLPD Total and is prone to buffer
  overflow and authentication bypass vulnerabilities.

  Vulnerability Insight:
  The issues are due to,
  - an error in Line Printer Daemon Service (LPDService.exe), when processing
    print jobs with an overly long control file on default TCP port 515/13500.
  - an error in authentication checks in the Line Printer Daemon (LPD).

  Impact: Successful exploitation could allow execution of arbitrary code or
  crashing the remote wincomlpd service by simply using negative values like
  0x80/0xff for the 8 bit numbers and 0x8000/0xffff for the data blocks.

  Impact Level: System

  Affected Software/OS:
  WinCom LPD Total 3.0.2.623 and prior on Windows.

  Fix: No solution/patch is available as on 26th November, 2008. Information
  regarding this issue will be updated once the solution details are
  available.
  For updates refer, http://www.clientsoftware.com.au/download.php

  References:
  http://secunia.com/advisories/28763
  http://aluigi.org/adv/wincomalpd-adv.txt
  http://www.frsirt.com/english/advisories/2008/0410

  CVSS Score:
    CVSS Base Score     : 9.3 (AV:N/AC:M/Au:NR/C:C/I:C/A:C)
    CVSS Temporal Score : 8.4
  Risk factor: High";

  script_description(desc);
  script_summary("Check for the Version of WinCom LPD Total");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (C) 2008 Intevation GmbH");
  script_family("Denial of Service");
  script_dependencies("secpod_reg_enum.nasl");
  script_require_keys("SMB/WindowsVersion");
  script_require_ports(139, 445);
  exit(0);
}


include("smb_nt.inc");
include("version_func.inc");
include("secpod_smb_func.inc");

if(!get_kb_item("SMB/WindowsVersion")){
  exit(0);
}

lpdport = 515;
if(!get_port_state(lpdport))
{
  lpdport = 13500;
  if(!get_port_state(lpdport)){
    exit(0);
  }
}

lpdVer = registry_get_sz(key:"SYSTEM\CurrentControlSet\Services\LPDService",
                         item:"ImagePath");
if(!lpdVer){
  exit(0);
}

share = ereg_replace(pattern:"([a-zA-Z]):.*", replace:"\1$", string:lpdVer);
file =  ereg_replace(pattern:"[a-zA-Z]:(.*)", replace:"\1", string:lpdVer);

lpdVer = GetVer(file:file, share:toupper(share));
if(!lpdVer){
  exit(0);
}

if(version_is_less_equal(version:lpdVer, test_version:"3.0.2.623")){
  security_hole(lpdport);
}
