###############################################################################
# OpenVAS Vulnerability Test
# $Id: gb_wordpress_mult_vuln_jul09.nasl 3414 2009-07-17 15:31:09Z jul $
#
# WordPress Multiple Vulnerabilities - July09
#
# Authors:
# Antu Sanadi <santu@secpod.com>
#
# Copyright:
# Copyright (c) 2009 Intevation GmbH, http://www.intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(800657);
  script_version("$Revision: 1.0 $");
  script_cve_id("CVE-2009-2432", "CVE-2009-2431", "CVE-2009-2336",
                "CVE-2009-2335", "CVE-2009-2334");
  script_bugtraq_id(35581, 35584);
  script_name("WordPress Multiple Vulnerabilities - July09");
  desc = "

  Overview:
  The host is running WordPress and is prone to Multiple Vulnerabilities.

  Vulnerability Insight:
  - Error in 'wp-settings.php' which may disclose the sensitive information via
    a direct request.
  - username of a post's author is placed in an HTML comment, which allows
    remote attackers to obtain sensitive information by reading the HTML source.
  - Error occur when user attampt for failed login or password request depending
    on whether the user account exists, and it can be exploited by enumerate
    valid usernames.
  - wp-admin/admin.php does not require administrative authentication
    to access the configuration of a plugin, which allows attackers to specify a
    configuration file in the page parameter via collapsing-archives/options.txt,
    related-ways-to-take-action/options.php, wp-security-scan/securityscan.php,
    akismet/readme.txt and wp-ids/ids-admin.php.

  Impact:
  Successful exploitation will let the attackers to view the content of plugins
  configuration pages, inject malicious scripting code, or gain knowledge of
  sensitive username information.

  Impact Level: Application

  Affected Software/OS:
  WordPress version prior to 2.8.1 on all running platform.

  Fix: Update to Version 2.8.1
  http://wordpress.org/download/

  References:
  http://www.vupen.com/english/advisories/2009/1833
  http://securitytracker.com/alerts/2009/Jul/1022528.html
  http://www.securityfocus.com/archive/1/archive/1/504795/100/0/threaded

  CVSS Score:
    CVSS Base Score     : 6.4 (AV:N/AC:L/Au:NR/C:P/I:P/A:N)
    CVSS Temporal Score : 5.0
  Risk factor: Medium";

  script_description(desc);
  script_summary("Check for the Version of WordPress");
  script_category(ACT_MIXED_ATTACK);
  script_copyright("Copyright (C) 2009 Intevation GmbH");
  script_family("Web application abuses");
  script_dependencies("secpod_wordpress_detect_900182.nasl");
  script_require_ports("Services/www", 80);
  exit(0);
}


include("http_func.inc");
include("version_func.inc");

wpmuPort = get_http_port(default:80);
if(!wpmuPort){
  exit(0);
}

wpVer = get_kb_item("www/" + wpmuPort + "/WordPress");
if(!wpVer){
  exit(0);
}

wpVer = eregmatch(pattern:"^(.+) under (/.*)$", string:wpVer);

if((wpVer[2] != NULL) && (!safe_checks()))
{
  sndReq = http_get(item:string(wpVer[2], "/wp-settings.php"), port:wpmuPort);
  rcvRes = http_send_recv(port:wpmuPort, data:sndReq);
  if("ABSPATHwp-include" >< rcvRes && "include_path" >< rcvRes)
  {
    security_warning(wpmuPort);
    exit(0);
  }
}

if(wpVer[1] != NULL)
{
  if(version_is_less(version:wpVer[1], test_version:"2.8.1")){
    security_warning(wpmuPort);
  }
}
