###############################################################################
# OpenVAS Vulnerability Test
# $Id: gb_wordpress_mult_vuln_may09.nasl 2025 2009-05-06 14:15:12Z may $
#
# Wordpress Multiple Vulnerabilities
#
# Authors:
# Sujit Ghosal <sghosal@secpod.com>
#
# Copyright:
# Copyright (c) 2009 Intevation GmbH, http://www.intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(800704);
  script_version("$Revision: 1.0 $");
  script_cve_id("CVE-2008-6767", "CVE-2008-6762");
  script_name("Wordpress Multiple Vulnerabilities");
  desc = "

  Overview: This host has Wordpress installed and is prone to Multiple
  Vulnerabilities.

  Vulnerability Insight:
  Multiple flaws are due to lack of sanitization in user supplied data which
  can be exploited through 'wp-admin/upgrade.php' via a direct request and
  'wp-admin/upgrade.php' via a URL in the backto parameter.

  Impact:
  Attackers can exploit this issue to causes denial of service or to redirect
  the URL to any malicious website and conduct phishing attacks.

  Impact Level: Application

  Affected Software/OS:
  Wordpress version 2.6.x

  Fix: Upgrade your wordpress to the latest version 2.7.1
  http://wordpress.org

  References:
  http://osvdb.org/52213
  http://archives.neohapsis.com/archives/bugtraq/2008-12/0226.html

  CVSS Score:
    CVSS Base Score     : 10.0 (AV:N/AC:L/Au:NR/C:C/I:C/A:C)
    CVSS Temporal Score : 7.8
  Risk factor: High";

  script_description(desc);
  script_summary("Check for the version of Wordpress");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (C) 2009 Intevation GmbH");
  script_family("Web application abuses");
  script_dependencies("secpod_wordpress_detect_900182.nasl");
  script_require_ports("Services/www", 80);
  exit(0);
}


include("version_func.inc");
include("http_func.inc");

wordpressPort = get_http_port(default:80);
if(!wordpressPort){
  exit(0);
}

if(!get_port_state(wordpressPort)){
  exit(0);
}

version = get_kb_item("www/" + wordpressPort + "/WordPress");
version = eregmatch(pattern:"^(.+) under (/.*)$", string:version);
if(version[1] == NULL){
  exit(0);
}

if(version_in_range(version:version[1], test_version:"2.6", test_version2:"2.6.3")){
  security_hole(wordpressPort);
}
