#
# This script was written by George A. Theall, <theall@tifaware.com>.
#
# See the Nessus Scripts License for details.
#

if (description) {
  script_id(14634);
  script_bugtraq_id(10668);
  script_version("$Revision: 4329 $");

  name = "IlohaMail Email Header HTML Injection Vulnerability";
  script_name(name);
 
  desc = "
Synopsis :

The remote web server contains a PHP script which is vulnerable to a cross site
scripting vulnerability.

Description :

The target is running at least one instance of IlohaMail version
0.8.12 or earlier.  Such versions do not properly sanitize message
headers, leaving users vulnerable to XSS attacks.  For example, a
remote attacker could inject Javascript code that steals the user's
session cookie and thereby gain access to that user's account.


Solution : 

Upgrade to IlohaMail version 0.8.13 or later.

Risk factor :

Low / CVSS Base Score : 3 
(AV:R/AC:H/Au:NR/C:P/A:N/I:N/B:C)";
  script_description(desc);
 
  summary = "Checks for Email Header HTML Injection vulnerability in IlohaMail";
  script_summary(summary);
 
  script_category(ACT_GATHER_INFO);
  script_copyright("This script is Copyright (C) 2004 George A. Theall");

  family = "Web application abuses";
  script_family(family);

  script_dependencie("global_settings.nasl", "ilohamail_detect.nasl");
  script_require_ports("Services/www", 80);

  exit(0);
}

include("global_settings.inc");
include("http_func.inc");

host = get_host_name();
port = get_http_port(default:80);
if (debug_level) display("debug: searching for IlohaMail Email Header HTML Injection vulnerability on ", host, ":", port, ".\n");

if (!get_port_state(port)) exit(0);

# Check each installed instance, stopping if we find a vulnerable version.
installs = get_kb_list(string("www/", port, "/ilohamail"));
if (isnull(installs)) exit(0);
foreach install (installs) {
  matches = eregmatch(string:install, pattern:"^(.+) under (/.*)$");
  if (!isnull(matches)) {
    ver = matches[1];
    dir = matches[2];
    if (debug_level) display("debug: checking version ", ver, " under ", dir, ".\n");

   if (ver =~ "^0\.([0-7].*|8\.([0-9]|1[0-2])(-Devel)?$)") {
      security_note(port);
      exit(0);
    }
  }
}
