###############################################################################
# OpenVAS Vulnerability Test
# $Id: mailman_37984.nasl 6597 2010-01-29 16:41:41Z mime $
#
# GNU Mailman Unspecified Privilege Escalation Vulnerability
#
# Authors:
# Michael Meyer
#
# Copyright:
# Copyright (c) 2010 Greenbone Networks GmbH
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if (description)
{
 script_id(100475);
 script_bugtraq_id(37984);
 script_version ("1.0-$Revision: 6597 $");

 script_name("GNU Mailman Unspecified Privilege Escalation Vulnerability");

desc = "Overview:
Mailman is prone to an unspecified privilege-escalation scripting
vulnerability.

 Few technical details are available at this time.

Local attackers may exploit this issue to obtain elevated privileges
and compromise a computer.

This issue is known to affect Mailman 2.0.2 and 2.0.4; other versions
may be vulnerable as well.

Solution:
Updates are available. Please see the references for more information.

References:
http://www.securityfocus.com/bid/37984
http://mailman.sourceforge.net/index.html

Risk factor : Medium";

 script_description(desc);
 script_summary("Determine if Mailman version is 2.0.2 or 2.0.4");
 script_category(ACT_GATHER_INFO);
 script_family("Web application abuses");
 script_copyright("This script is Copyright (C) 2010 Greenbone Networks GmbH");
 script_dependencies("mailman_detect.nasl");
 script_require_ports("Services/www", 80);
 script_exclude_keys("Settings/disable_cgi_scanning");
 exit(0);
}

include("http_func.inc");
include("version_func.inc");

port = get_http_port(default:80);
if(!get_port_state(port))exit(0);

if(!version = get_kb_item(string("www/", port, "/Mailman")))exit(0);
if(!matches = eregmatch(string:version, pattern:"^(.+) under (/.*)$"))exit(0);

vers = matches[1];

if(!isnull(vers) && vers >!< "unknown") {

  if(version_is_equal(version: vers, test_version: "2.0.2") ||
     version_is_equal(version: vers, test_version: "2.0.4")) {
      security_warning(port:port);
      exit(0);
  }

}

exit(0);
