# OpenVAS Vulnerability Test
# $Id$
# Description: Auto-generated from advisory MDVSA-2009:024 (php4)
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2009 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largely excerpted from the referenced
# advisory, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# or at your option, GNU General Public License version 3,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#
                                                                                
if(description)
{
 script_id(63251);
 script_cve_id("CVE-2008-3658", "CVE-2008-3659", "CVE-2008-3660");
 script_version ("$");
 name["english"] = "Mandrake Security Advisory MDVSA-2009:024 (php4)";
 script_name(english:name["english"]);

 desc["english"] = "
The remote host is missing an update to php4
announced via advisory MDVSA-2009:024.

A buffer overflow in the imageloadfont() function in PHP allowed
context-dependent attackers to cause a denial of service (crash)
and potentially execute arbitrary code via a crafted font file
(CVE-2008-3658).

A buffer overflow in the memnstr() function allowed context-dependent
attackers to cause a denial of service (crash) and potentially execute
arbitrary code via the delimiter argument to the explode() function
(CVE-2008-3659).

PHP, when used as a FastCGI module, allowed remote attackers to cause
a denial of service (crash) via a request with multiple dots preceding
the extension (CVE-2008-3660).

The updated packages have been patched to correct these issues.

Affected: Corporate 3.0, Corporate 4.0, Multi Network Firewall 2.0

Solution:
To upgrade automatically use MandrakeUpdate or urpmi.  The verification
of md5 checksums and GPG signatures is performed automatically for you.

https://secure1.securityspace.com/smysecure/catid.html?in=MDVSA-2009:024

Risk factor : High";

 script_description(english:desc["english"]);

 summary["english"] = "Mandrake Security Advisory MDVSA-2009:024 (php4)";
 script_summary(english:summary["english"]);

 script_category(ACT_GATHER_INFO);

 script_copyright(english:"Copyright (c) 2009 E-Soft Inc. http://www.securityspace.com");
 family["english"] = "Mandrake Local Security Checks";
 script_family(english:family["english"]);
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/rpms");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-rpm.inc");
vuln = 0;
if(isrpmvuln(pkg:"libphp_common432", rpm:"libphp_common432~4.3.4~4.29.C30mdk", rls:"MNDK_3.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"php432-devel", rpm:"php432-devel~4.3.4~4.29.C30mdk", rls:"MNDK_3.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"php-cgi", rpm:"php-cgi~4.3.4~4.29.C30mdk", rls:"MNDK_3.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"php-cli", rpm:"php-cli~4.3.4~4.29.C30mdk", rls:"MNDK_3.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"lib64php_common432", rpm:"lib64php_common432~4.3.4~4.29.C30mdk", rls:"MNDK_3.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"libphp4_common4", rpm:"libphp4_common4~4.4.4~1.9.20060mlcs4", rls:"MNDK_4.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"php4-cgi", rpm:"php4-cgi~4.4.4~1.9.20060mlcs4", rls:"MNDK_4.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"php4-cli", rpm:"php4-cli~4.4.4~1.9.20060mlcs4", rls:"MNDK_4.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"php4-devel", rpm:"php4-devel~4.4.4~1.9.20060mlcs4", rls:"MNDK_4.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"lib64php4_common4", rpm:"lib64php4_common4~4.4.4~1.9.20060mlcs4", rls:"MNDK_4.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"libphp_common432", rpm:"libphp_common432~4.3.4~4.29.C30mdk", rls:"MNDK_2.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"php-cgi", rpm:"php-cgi~4.3.4~4.29.C30mdk", rls:"MNDK_2.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"php-cli", rpm:"php-cli~4.3.4~4.29.C30mdk", rls:"MNDK_2.0")) {
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
