###############################################################################
# OpenVAS Vulnerability Test
# $Id: monkey_http_37307.nasl 6137 2009-12-15 18:11:56Z mime $
#
# Monkey HTTP Daemon Invalid HTTP 'Connection' Header Denial Of Service Vulnerability
#
# Authors:
# Michael Meyer
#
# Copyright:
# Copyright (c) 2009 Greenbone Networks GmbH
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if (description)
{
 script_id(100397);
 script_bugtraq_id(37307);
 script_version ("1.0-$Revision: 6137 $");

 script_name("Monkey HTTP Daemon Invalid HTTP 'Connection' Header Denial Of Service Vulnerability");

desc = "Overview:
Monkey HTTP Daemon is prone to a denial-of-service vulnerability.

Remote attackers can exploit this issue to cause the application to
crash, denying service to legitimate users.

Versions prior to Monkey HTTP Daemon 0.9.3 are vulnerable.

Solution:
Updates are available; please see the references for more information.

References:
http://www.securityfocus.com/bid/37307
http://groups.google.com/group/monkeyd/browse_thread/thread/055b4e9b83973861/c0e013d166ae1eb3?show_docid=c0e013d166ae1eb3
http://monkeyd.sourceforge.net/
http://census-labs.com/news/2009/12/14/monkey-httpd/
http://www.securityfocus.com/archive/1/508442

Risk factor : Medium";

 script_description(desc);
 script_summary("Determine if Monkey HTTP Daemon is prone to a denial-of-service vulnerability");
 script_category(ACT_GATHER_INFO);
 script_family("Web Servers");
 script_copyright("This script is Copyright (C) 2009 Greenbone Networks GmbH");
 script_dependencies("find_service.nes");
 script_require_ports("Services/www", 2001);
 exit(0);
}


include("http_func.inc");
include("version_func.inc");

port = get_http_port(default:2001);
if(!get_port_state(port))exit(0);

banner = get_http_banner(port: port);
if(!banner)exit(0);

if("Server: Monkey/" >!< banner)exit(0);
version = eregmatch(pattern: "Server: Monkey/([0-9.]+)", string: banner);
if(isnull(version[1]))exit(0);

   if(version_is_less(version: version[1], test_version: "0.9.3")) {
        security_note(port:port);
        exit(0); 
   }

exit(0);

