###############################################################################
# OpenVAS Vulnerability Test
# $Id: mt_37638.nasl 6332 2010-01-06 17:07:55Z mime $
#
# Movable Type Unspecified Security Bypass Vulnerability
#
# Authors:
# Michael Meyer
#
# Copyright:
# Copyright (c) 2010 Greenbone Networks GmbH
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if (description)
{
 script_id(100430);
 script_bugtraq_id(37638);
 script_version ("1.0-$Revision: 6332 $");

 script_name("Movable Type Unspecified Security Bypass Vulnerability");

desc = "Overview:
Movable Type is prone to an unspecified security-bypass vulnerability.

Very little is known about this issue at this time (06.01.2010). We will update
this BID as more information emerges.

This issue affects versions prior to 4.27 and 5.01.

Solution:
The vendor has released fixes. Please see the references for more
information.

References:
http://www.securityfocus.com/bid/37638
http://www.movabletype.jp/blog/movable_type_501.html
http://www.movabletype.org/
http://jvn.jp/en/jp/JVN09872874/index.html

Risk factor : Medium";

 script_description(desc);
 script_summary("Determine if Movable Type version is < 4.27 or < 5.01");
 script_category(ACT_GATHER_INFO);
 script_family("Web application abuses");
 script_copyright("This script is Copyright (C) 2010 Greenbone Networks GmbH");
 script_dependencies("mt_detect.nasl");
 script_require_ports("Services/www", 80);
 script_exclude_keys("Settings/disable_cgi_scanning");
 exit(0);
}

include("http_func.inc");
include("http_keepalive.inc");
include("version_func.inc");

port = get_http_port(default:80);
if(!get_port_state(port))exit(0);

if(!version = get_kb_item(string("www/", port, "/movabletype")))exit(0);
if(!matches = eregmatch(string:version, pattern:"^(.+) under (/.*)$"))exit(0);

vers = matches[1];

if(!isnull(vers) && vers >!< "unknown") {

  if(vers =~ "^5\.") {
    if(version_is_less(version: vers, test_version: "5.01")) {
        security_warning(port:port);
        exit(0);
    }
  } 
  else if(version_is_less(version: vers, test_version: "4.27")) {
    security_warning(port:port);
    exit(0);
  }  
}

exit(0);
