###############################################################################
# OpenVAS Vulnerability Test
# $Id: nagios_35464.nasl 6984 2010-03-17 12:20:23Z mime $
#
# Nagios 'statuswml.cgi' Remote Arbitrary Shell Command Injection
# Vulnerability
#
# Authors
# Michael Meyer
#
# Copyright:
# Copyright (c) 2009 Greenbone Networks GmbH
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if (description)
{
 script_id(100229);
 script_bugtraq_id(35464);
 script_cve_id("CVE-2009-2288");
 script_version ("1.0");

 script_name("Nagios 'statuswml.cgi' Remote Arbitrary Shell Command Injection Vulnerability");
 desc = "

 Overview:
  Nagios is prone to a remote command-injection vulnerability because
  it fails to adequately sanitize user-supplied input data.

  Remote attackers can exploit this issue to execute arbitrary shell
  commands with the privileges of the user running the application.

  Note that for an exploit to succeed, access to the WAP interface's
  ping feature must be allowed.

  Versions prior to Nagios 3.1.1 are vulnerable. 

 Solution:
  The vendor has released updates. Please see http://www.nagios.org/
  for more information.

 See also:
  http://www.securityfocus.com/bid/35464

 Risk factor : Medium";

 script_description(desc);
 script_summary("Check if the Version of Nagios is < 3.1.1");
 script_category(ACT_GATHER_INFO);
 script_family("General");
 script_copyright("This script is Copyright (C) 2009 Greenbone Networks GmbH");
 script_dependencie("nagios_detect.nasl");
 script_require_ports("Services/www", 80);
 script_exclude_keys("Settings/disable_cgi_scanning");
 exit(0);
}

include("http_func.inc");
include("version_func.inc");

port = get_http_port(default:80);

if(!get_port_state(port))exit(0);

if(!version = get_kb_item(string("www/", port, "/nagios")))exit(0);
if(!matches = eregmatch(string:version, pattern:"^(.+) under (/.*)$"))exit(0);

vers = matches[1];

if(!isnull(vers) && vers >!< "unknown") {

  if(version_is_less(version: vers, test_version: "3.1.1")) {
      security_warning(port:port);
      exit(0);
  }  

}

exit(0);
