###############################################################################
# OpenVAS Vulnerability Test
# $Id$
#
# Nagios Web Interface Privilege Escalation Vulnerability
#
# Authors
# Michael Meyer
#
# Copyright:
# Copyright (c) 2009 Greenbone Networks GmbH
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if (description)
{
 script_id(100189);
 script_bugtraq_id(32156);
 script_cve_id("CVE-2008-5027");
 script_version ("1.0");

 script_name("Nagios Web Interface Privilege Escalation Vulnerability");
 desc = "

 Overview:
  Nagios is prone to an unspecified privilege-escalation scripting
  vulnerability.

  An attacker with low-level privileges may exploit this issue to
  bypass authorization and cause arbitrary commands to run within the
  context of the Nagios server. This may aid in further attacks.

  Few technical details are available at this time; we will update
  this BID as more information emerges.

  The issue affects versions prior to Nagios 3.0.5. 

 Solution:
  The vendor has released updates. Please see http://www.nagios.org/
  for more information.

 See also:
  http://www.securityfocus.com/bid/32156

 Risk factor : Medium";

 script_description(desc);
 script_summary("Check if the Version of Nagios is < 3.0.5");
 script_category(ACT_GATHER_INFO);
 script_family("General");
 script_copyright("This script is Copyright (C) 2009 Greenbone Networks GmbH");
 script_dependencie("nagios_detect.nasl");
 script_require_ports("Services/www", 80);
 script_exclude_keys("Settings/disable_cgi_scanning");
 exit(0);
}

include("http_func.inc");
include("version_func.inc");

port = get_http_port(default:80);

if(!get_port_state(port))exit(0);

if(!version = get_kb_item(string("www/", port, "/nagios")))exit(0);
if(!matches = eregmatch(string:version, pattern:"^(.+) under (/.*)$"))exit(0);

vers = matches[1];

if(!isnull(vers) && vers >!< "unknown") {

  if(version_is_less(version: vers, test_version: "3.0.5")) {
      security_warning(port:port);
      exit(0);
  }  

}

exit(0);
