###############################################################################
# OpenVAS Vulnerability Test
# $Id: net2ftp_34440.nasl 6984 2010-03-17 12:20:23Z mime $
#
# net2ftp Multiple Cross-Site Scripting Vulnerabilities
#
# Authors
# Michael Meyer
#
# Copyright:
# Copyright (c) 2009 Greenbone Networks GmbH
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if (description)
{
 script_id(100126);
 script_bugtraq_id(34440);
 script_version ("1.0");

 script_name("net2ftp Multiple Cross-Site Scripting Vulnerabilities");
 desc = "

 Overview:
  The net2ftp program is prone to multiple cross-site scripting
  vulnerabilities because it fails to properly sanitize user-supplied
  input.

  An attacker can exploit these issues to execute arbitrary script
  code in the browser of an unsuspecting user in the context of the
  affected site. This may help the attacker steal cookie-based
  authentication credentials and launch other attacks.

  These issues affect net2ftp 0.98 and earlier. 

 See also:
  http://www.securityfocus.com/bid/34440

 Risk factor : Medium";

 script_description(desc);
 script_summary("Determine if net2ftp is vulnerable to Multiple XSS");
 script_category(ACT_GATHER_INFO);
 script_family("Web application abuses");
 script_copyright("This script is Copyright (C) 2009 Greenbone Networks GmbH");
 script_dependencie("net2ftp_detect.nasl");
 script_require_ports("Services/www", 80);
 script_exclude_keys("Settings/disable_cgi_scanning");
 exit(0);
}

include("http_func.inc");
include("http_keepalive.inc");
include("version_func.inc");

port = get_http_port(default:80);

if(!get_port_state(port))exit(0);
if(!can_host_php(port:port))exit(0);

if(!version = get_kb_item(string("www/", port, "/net2ftp")))exit(0);
if(!matches = eregmatch(string:version, pattern:"^(.+) under (/.*)$"))exit(0);

vers = matches[1];
dir  = matches[2];

if(!isnull(vers) && vers >!< "unknown") {

  if(version_is_less_equal(version: vers, test_version: "0.98")) {
    VULN = TRUE;
  }  

} else {  
# No version found, try to exploit.
  if(!isnull(dir)) {
     url = string(dir, '/index.php?state=login_small&errormessage=<script>alert(document.cookie)</script>');
     req = http_get(item:url, port:port);
     buf = http_keepalive_send_recv(port:port, data:req, bodyonly:FALSE);
     if( buf == NULL )continue;
     if(egrep(pattern:"<script>alert\(document\.cookie\)</script>", string: buf))
       {    
  	  VULN = TRUE;
       }
  }
}

if(VULN) {

  security_warning(port:port);
  exit(0);

}  
exit(0);
