###############################################################################
# OpenVAS Vulnerability Test
# $Id: nginx_37711.nasl 6391 2010-01-13 10:20:27Z mime $
#
# nginx Terminal Escape Sequence in Logs Command Injection Vulnerability
#
# Authors:
# Michael Meyer
#
# Copyright:
# Copyright (c) 2010 Greenbone Networks GmbH
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if (description)
{
 script_id(100441);
 script_bugtraq_id(37711);
script_cve_id("CVE-2009-4487");
script_version ("1.0-$Revision: 6391 $");

script_name("nginx Terminal Escape Sequence in Logs Command Injection Vulnerability");

desc = "Overview:
The 'nginx' program is prone to a command-injection vulnerability
because it fails to adequately sanitize user-supplied input in
log files.

Attackers can exploit this issue to execute arbitrary commands in
a terminal.

This issue affects nginx 0.7.64; other versions may also be affected.

References:
http://www.securityfocus.com/bid/37711
http://nginx.net/
http://www.securityfocus.com/archive/1/508830

Risk factor : Medium";

 script_description(desc);
 script_summary("Determine if nginx version is 0.7.64");
 script_category(ACT_GATHER_INFO);
 script_family("Web Servers");
 script_copyright("This script is Copyright (C) 2010 Greenbone Networks GmbH");
 script_dependencies("nginx_detect.nasl");
 script_require_ports("Services/www", 80);
 exit(0);
}

include("http_func.inc");
include("version_func.inc");

port = get_http_port(default:80);
if(!get_port_state(port))exit(0);

if(!vers = get_kb_item(string("nginx/", port, "/version")))exit(0);

if(!isnull(vers) && vers >!< "unknown") {
  if(version_is_equal(version: vers, test_version:"0.7.64")) {
      security_warning(port:port);
      exit(0);
  }
}

exit(0);     
