###############################################################################
# This script was written by David Maciejak <david dot maciejak at kyxar dot fr>
# based on work from
# (C) Tenable Network Security
#
# Updated: 03/12/2009 Antu Sanadi <santu@secpod.com> 
#
# Ref: :: Operash ::
# This script is released under the GNU GPLv2
###############################################################################

if(description)
{
  script_id(14246);
  script_bugtraq_id(9279);
  script_version("$Revision: 4330 $");
  script_name("Opera relative path directory traversal file corruption vulnerability");
  desc = "
  The remote host is using Opera - an alternative web browser.
  This version of Opera is vulnerable to a file corruption vulnerability.
  This issue is exposed when a user is presented with a file dialog,
  which will cause the creation of a temporary file.
  It is possible to specify a relative path to another file on the system
  using directory traversal sequences when the download dialog is displayed.
  If the client user has write permissions to the attacker-specified file,
  it will be corrupted.

  This could be exploited to delete sensitive files on the systems.

  Solution : Install Opera 7.23 or newer.

  Risk factor : High";

  script_description(desc);
  script_summary("Determines the version of Opera.exe");
  script_category(ACT_GATHER_INFO);
  script_copyright("This script is Copyright (C) 2004 David Maciejak");
  script_family("Windows");
  script_dependencies("secpod_opera_detection_win_900036.nasl");
  script_require_keys("Opera/Win/Version");
  exit(0);
}


include("version_func.inc");

OperaVer = get_kb_item("Opera/Win/Version");
if(!OperaVer){
  exit(0);
}

if(version_is_less_equal(version:OperaVer, test_version:"7.22")){
  security_hole(0);
}
