###############################################################################
# This script was written by David Maciejak <david dot maciejak at kyxar dot fr>
# based on work from
# (C) Tenable Network Security
#
# Ref: d3thStaR <d3thStaR@rootthief.com>
#
# Updated: 03/12/2009 Antu Sanadi <santu@secpod.com>
#
# This script is released under the GNU GPLv2
#
###############################################################################

if(description)
{
  script_id(14248);
  script_cve_id("CVE-2004-1810");
  script_bugtraq_id(9869);
  script_version("$Revision: 4330 $");
  script_name("Opera web browser large javaScript array handling vulnerability");
  desc = "
  The remote host is using Opera - an alternative web browser.
  This version is vulnerable to an issue when handling
  large JavaScript arrays.

  In particular, it is possible to crash the browser when performing
  various operations on Array objects with 99999999999999999999999
  or 0x23000000 elements.

  The crash is due to a segmentation fault and may be indicative
  of an exploitable memory corruption vulnerability,
  possibly resulting in arbitrary code execution.

  Solution : Install Opera 7.50 or newer.
  Risk factor : High";

  script_description(desc);
  script_summary("Determines the version of Opera.exe");
  script_category(ACT_GATHER_INFO);
  script_copyright("This script is Copyright (C) 2004 David Maciejak");
  script_family("Windows");
  script_dependencies("secpod_opera_detection_win_900036.nasl");
  script_require_keys("Opera/Win/Version");
  exit(0);
}

include("version_func.inc");

OperaVer = get_kb_item("Opera/Win/Version");
if(!OperaVer){
  exit(0);
}

if(version_is_less_equal(version:OperaVer, test_version:"7.49")){
  security_hole(0);
}

