###############################################################################
# OpenVAS Vulnerability Test
# $Id:$
#
# osCommerce Detection
#
# Authors:
# Michael Meyer
#
# Copyright:
# Copyright (c) 2009 Greenbone Networks GmbH
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

# need desc here to modify it later in script.
desc = "
This host is running osCommerce, a widely installed open source shopping e-commerce solution.
See http://www.oscommerce.com for more information.

Risk factor : None";

if (description)
{
 script_id(100001);
 script_version ("1.0");

 script_name("osCommerce Detection");  

 script_description(desc);
 script_summary("Checks for the presence of OsCommerce");
 script_category(ACT_GATHER_INFO);
 script_family("General");
 script_copyright("This script is Copyright (C) 2009 Greenbone Networks GmbH");
 script_dependencie("find_service.nes", "http_version.nasl");
 script_require_ports("Services/www", 80);
 script_exclude_keys("Settings/disable_cgi_scanning");
 exit(0);
}

include("http_func.inc");
include("http_keepalive.inc");
include("global_settings.inc");

port = get_http_port(default:80);

if(!get_port_state(port))exit(0);
if(!can_host_php(port:port)) exit(0);

dirs = make_list("/oscommerce","/store","/catalog","/osc","/shop",cgi_dirs());
x=0;

foreach dir (dirs) {

 url = string(dir, "/checkout_process.php"); 
 req = http_get(item:url, port:port);
 buf = http_keepalive_send_recv(port:port, data:req, bodyonly:FALSE);  
 if( buf == NULL ) exit(0);;

 ### looking for osCsid. If found, it is a osc
 if( "osCsid" >< buf )  
  { 
    if(strlen(dir)>0) {   
        installations[x] = dir;
    } else {
    	installations[x] = string("/");
    }	
  }
   ### If osCsid not found, look for typical osc files.
  else if  ( egrep(pattern:".*Location:.*login.php\?+.*=+.*", string: buf) ||             
            (egrep(pattern: "Set-Cookie:.*cookie_test=please_accept_for_session", string: buf1) && 
    	     egrep(pattern: "Location:.*login.php.*", string: buf1)) )  
  {     
    url1 = string(dir, "/address_book_process.php"); 
    req1 = http_get(item:url1, port:port);
    buf1 = http_keepalive_send_recv(port:port, data:req1, bodyonly:FALSE); 
    if( buf1 == NULL ) exit(0);     

    if ( egrep(pattern:".*Location:.*login.php\?+.*=+.*", string: buf) ||             
        (egrep(pattern: "Set-Cookie:.*cookie_test=please_accept_for_session", string: buf1) && 
    	 egrep(pattern: "Location:.*login.php.*", string: buf1)) )  
    {             
       url2 = string(dir, "/product_info.php"); 
       req2 = http_get(item:url2, port:port);
       buf2 = http_keepalive_send_recv(port:port, data:req2, bodyonly:FALSE); 
       if( buf2 == NULL ) exit(0); 

       if (ereg(pattern: "^HTTP/1\.[01] +200", string: buf2)) {       
           if(strlen(dir)>0) {   
    	        installations[x] = dir;
    	   } else {
        	installations[x] = string("/");
    	   }	
       }
    } 
  }  
  x++;
}

if(installations) {
    info = string("None\n\nOsCommerce was detected on the remote host in the following directory(s):\n\n"); 
    foreach found (installations) {
    	if (!get_kb_item("Software/osCommerce")) {
    	    set_kb_item(name:"Software/osCommerce", value: TRUE);
	}     
    	info += string(found, "\n"); 
    	set_kb_item(name:"Software/osCommerce/dir", value: found);
	set_kb_item(name: string("www/", port, "/oscommerce"), value: string("unknown under ",found));
    }
   
    desc = ereg_replace(
    	string:desc,
    	pattern:"None$",
    	replace:info
    );    
   
   if(report_verbosity > 0) { 
     security_note(port:port,data:desc);
   }  
   exit(0);
}

exit(0);
