# nnposter
# GPL
# kst-depend-rpc


    desc="
Synopsis :

It is possible to determine the version of the remote web application. 

Description :

OpenVAS was able to determine the software version of the Packeteer web
management interface running on the remote host. 

Risk factor :

None";


if (description)
    {
    script_id(80033);
    script_version ("$Revision: 1.1 $");

    name="Packeteer Web Management Interface Version";
    script_name(name);

    script_description(desc);

    summary="Tests for Packeteer web interface version";
    script_summary(summary);

    family="Web application abuses";
    script_family(family);

    script_category(ACT_GATHER_INFO);
    script_copyright("This script is Copyright (c) 2006-2007 nnposter");
    script_dependencies("packeteer_web_login.nasl");
    script_require_keys("www/packeteer");
    script_require_ports("Services/www",80);
    exit(0);
    }

# Notes:
# - Info page is bigger than 8K and PacketShaper does not use Content-Length.
#   The script uses custom http_send_recv_length() to retrieve the entire page.


include("http_func.inc");
include("misc_func.inc");


if (!get_kb_item("www/packeteer")) exit(0);


function set_cookie (data,cookie)
{
local_var EOL,req;
EOL='\r\n';
req=ereg_replace(string:data,pattern:EOL+'Cookie:[^\r\n]+',replace:"");
req=ereg_replace(string:req,pattern:EOL+EOL,replace:EOL+cookie+EOL);
return req;
}


function http_send_recv_length (port,data,length)
{
local_var sock,resp;
sock=http_open_socket(port);
if (!sock) return;
send(socket:sock,data:data);
resp=http_recv_length(socket:sock,bodylength:length);
http_close_socket(sock);
return resp;
}


function get_version (port,cookie)
{
local_var req,resp,match;
if (!port || !cookie) return;
if (!get_tcp_port_state(port)) return;
req=set_cookie(data:http_get(item:"/info.htm",port:port),cookie:cookie);
resp=http_send_recv_length(port:port,data:req,length:64000);
if (!resp) return;
match=eregmatch(
        pattern:'makeState\\("Software(.nbsp.| )Version:", *"([0-9A-Za-z.]+)',
        string:resp);
return match[2];
}


port=get_http_port(default:80);
product=get_kb_item("www/"+port+"/packeteer");
if (!get_tcp_port_state(port) || !product) exit(0);
if (!get_kb_item('/tmp/http/auth/'+port)) exit(0);

version=get_version(port:port,cookie:get_kb_item("/tmp/http/auth/"+port));
if (!version) exit(0);

replace_kb_item(name:"www/"+port+"/packeteer/version",value:version);
report = string(
  desc,
  "\n\n",
  "Plugin output :\n",
  "\n",
  "Packeteer "+product+" web interface version is "+version
);
security_note(port:port,data:report);
