###############################################################################
# OpenVAS Vulnerability Test
# $Id: phpFaber_cms_37329.nasl 6146 2009-12-16 11:39:06Z mime $
#
# phpFaber CMS 'module.php' Cross Site Scripting Vulnerability
#
# Authors:
# Michael Meyer
#
# Copyright:
# Copyright (c) 2009 Greenbone Networks GmbH
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if (description)
{
 script_id(100401);
 script_bugtraq_id(37329);
 script_version ("1.0-$Revision: 6146 $");

 script_name("phpFaber CMS 'module.php' Cross Site Scripting Vulnerability");

desc = "Overview:
phpFaber CMS is prone to a cross-site scripting vulnerability because
it fails to properly sanitize user-supplied input.

An attacker may leverage this issue to execute arbitrary script code
in the browser of an unsuspecting user in the context of the affected
site. This may allow the attacker to steal cookie-based authentication
credentials and to launch other attacks.

References:
http://www.securityfocus.com/bid/37329
http://www.phpfaber.com/i/products/cms/

Risk factor : Medium";

 script_description(desc);
 script_summary("Determine if phpFaber CMS is prone to a cross-site scripting vulnerability");
 script_category(ACT_GATHER_INFO);
 script_family("Web application abuses");
 script_copyright("This script is Copyright (C) 2009 Greenbone Networks GmbH");
 script_dependencies("find_service.nes", "http_version.nasl");
 script_require_ports("Services/www", 80);
 script_exclude_keys("Settings/disable_cgi_scanning");
 exit(0);
}

include("http_func.inc");
include("http_keepalive.inc");
include("global_settings.inc");
   
port = get_http_port(default:80);
if(!get_port_state(port))exit(0);
if(!can_host_php(port:port))exit(0);

dirs = make_list("/","/cms",cgi_dirs());

foreach dir (dirs) {
   
  url = string(dir, "/module.php?mod=<script>alert(8154711)</script>"); 
  req = http_get(item:url, port:port);

  buf = http_keepalive_send_recv(port:port, data:req, bodyonly:FALSE);  
  if( buf == NULL )continue;

  if(egrep(pattern: "<code>Module '<script>alert(8154711)</script>' not found</code>", string: buf, icase: TRUE)) {
     
    security_warning(port:port);
    exit(0);

  }
}

exit(0);

