###############################################################################
# OpenVAS Vulnerability Test
# $Id: phpScheduleIt_31520.nasl 6984 2010-03-17 12:20:23Z mime $
#
# phpScheduleIt 'reserve.php' Remote Code Execution Vulnerability
#
# Authors:
# Michael Meyer
#
# Copyright:
# Copyright (c) 2009 Greenbone Networks GmbH
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if (description)
{
 script_id(100234);
 script_bugtraq_id(31520);
 script_version ("1.0");

 script_name("phpScheduleIt 'reserve.php' Remote Code Execution Vulnerability");

desc = "

Overview:
phpScheduleIt is prone to a vulnerability that lets remote attackers
execute arbitrary code because the application fails to sanitize user-
supplied input.

An attacker can leverage this issue to execute arbitrary PHP code on
an affected computer with the privileges of the webserver process.

phpScheduleIt 1.2.10 is vulnerable; other versions may also be
affected.

References:
http://www.securityfocus.com/bid/31520
http://www.php.brickhost.com/


Risk factor : High";

 script_description(desc);
 script_summary("Check if version of phpScheduleIt is <= 1.2.10");
 script_category(ACT_GATHER_INFO);
 script_family("Web application abuses");
 script_copyright("This script is Copyright (C) 2009 Greenbone Networks GmbH");
 script_dependencie("phpScheduleIt_detect.nasl");
 script_require_ports("Services/www", 80);
 script_exclude_keys("Settings/disable_cgi_scanning");
 exit(0);
}

include("http_func.inc");
include("version_func.inc");

port = get_http_port(default:80);
if(!get_port_state(port))exit(0);

if (!can_host_php(port:port)) exit(0);

if(!version = get_kb_item(string("www/", port, "/phpScheduleIt")))exit(0);
if(!matches = eregmatch(string:version, pattern:"^(.+) under (/.*)$"))exit(0);

vers = matches[1];

if(!isnull(vers) && vers >!< "unknown") {

  if(version_is_less_equal(version: vers, test_version: "1.2.10")) {
      security_hole(port:port);
      exit(0);
  }

}

exit(0);
