###############################################################################
# OpenVAS Vulnerability Test
# $Id: php_35867.nasl 6984 2010-03-17 12:20:23Z mime $
#
# PHP Interruptions and Calltime Arbitrary Code Execution Vulnerability
#
# Authors:
# Michael Meyer
#
# Copyright:
# Copyright (c) 2009 Greenbone Networks GmbH
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if (description)
{
 script_id(100252);
 script_bugtraq_id(35867);
 script_version ("1.0");

 script_name("PHP Interruptions and Calltime Arbitrary Code Execution Vulnerability");

desc = "

Overview:
PHP is prone to a vulnerability that an attacker could exploit to
execute arbitrary code with the privileges of the user running the
affected application. Successful exploits will compromise the
application and possibly the computer.


References:
http://www.securityfocus.com/bid/35867
http://www.php.net
http://www.blackhat.com/presentations/bh-usa-09/ESSER/BHUSA09-Esser-PostExploitationPHP-PAPER.pdf


Risk factor : High";

 script_description(desc);
 script_summary("Determine if PHP version is <= 5.2.10");
 script_category(ACT_GATHER_INFO);
 script_family("Web application abuses");
 script_copyright("This script is Copyright (C) 2009 Greenbone Networks GmbH");
 script_dependencies("gb_php_detect.nasl");
 script_require_ports("Services/www", 80);
 exit(0);
}

include("http_func.inc");
include("version_func.inc");

port = get_http_port(default:80);
if(!get_port_state(port))exit(0);

if (!can_host_php(port:port)) exit(0);

if(!vers = get_kb_item(string("www/", port, "/PHP")))exit(0);
if(!isnull(vers)) {

  if(version_is_less_equal(version: vers, test_version: "5.2.10")) {
      security_hole(port:port);
      exit(0);
  }

}

exit(0);
