###############################################################################
# OpenVAS Vulnerability Test
# $Id: php_5_2_13.nasl 6858 2010-02-27 18:39:22Z mime $
#
# PHP < 5.2.13 Multiple Vulnerabilities
#
# Authors:
# Michael Meyer
#
# Copyright:
# Copyright (c) 2010 Greenbone Networks GmbH
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if (description)
{
 script_id(100511);
 script_bugtraq_id(38182,38431,38430);
 script_version ("1.0-$Revision: 6858 $");
 script_name("PHP < 5.2.13 Multiple Vulnerabilities");

desc = "Overview:
The remote web server has installed a PHP Version which is prone to
Multiple Vulnerabilities.

1. A 'safe_mode' restriction-bypass vulnerability. Successful exploits
could allow an attacker to write session files in arbitrary
directions.

2. A 'safe_mode' restriction-bypass vulnerability. Successful exploits
could allow an attacker to access files in unauthorized locations or
create files in any writable directory.

3. An unspecified security vulnerability that affects LCG entropy.

PHP versions prior to 5.2.13 are affected. 

Solution:
Updates are available. Please see the references for details.

References:
http://www.securityfocus.com/bid/38182
http://www.securityfocus.com/bid/38431
http://www.securityfocus.com/bid/38430
http://securityreason.com/achievement_securityalert/82
http://www.php.net/releases/5_2_13.php
http://www.php.net
http://svn.php.net/viewvc/php/php-src/branches/PHP_5_2/ext/session/session.c?r1=293036&r2=294272
http://svn.php.net/viewvc/php/php-src/branches/PHP_5_3/ext/session/session.c?r1=293036&r2=294272

Risk factor : High";

 script_description(desc);
 script_summary("Determine if installed PHP version is < 5.2.13");
 script_category(ACT_GATHER_INFO);
 script_family("Web application abuses");
 script_copyright("This script is Copyright (C) 2010 Greenbone Networks GmbH");
 script_dependencies("gb_php_detect.nasl");
 script_require_ports("Services/www", 80);
 exit(0);
}

include("http_func.inc");
include("version_func.inc");

port = get_http_port(default:80);
if(!get_port_state(port))exit(0);

if (!can_host_php(port:port)) exit(0);

if(!vers = get_kb_item(string("www/", port, "/PHP")))exit(0);
if(!isnull(vers)) {

  if(version_is_less(version: vers, test_version: "5.2.13")) {
      security_hole(port:port);
      exit(0);
  }
}

exit(0);
