###############################################################################
# OpenVAS Vulnerability Test
# $Id: phpgroupware_35761.nasl 6984 2010-03-17 12:20:23Z mime $
#
# phpGroupWare Multiple Input Validation Vulnerabilities
#
# Authors:
# Michael Meyer
#
# Copyright:
# Copyright (c) 2009 Greenbone Networks GmbH
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if (description)
{
 script_id(100237);
 script_bugtraq_id(35761);
 script_version ("1.0");

 script_name("phpGroupWare Multiple Input Validation Vulnerabilities");

desc = "

Overview:
phpGroupWare is prone to multiple input-validation vulnerabilities
because it fails to sufficiently sanitize user-supplied data.

Exploiting these issues could allow an attacker to disclose sensitive
information, steal cookie-based authentication credentials, compromise
the application, access or modify data, or exploit latent
vulnerabilities in the underlying database.

phpGroupWare 0.9.16.12 is affected; other versions may also be
vulnerable.


References:
http://www.securityfocus.com/bid/35761
http://www.phpgroupware.org/


Risk factor : Low";

 script_description(desc);
 script_summary("Determine if phpGroupWare Version = 0.9.16.12");
 script_category(ACT_GATHER_INFO);
 script_family("Web application abuses");
 script_copyright("This script is Copyright (C) 2009 Greenbone Networks GmbH");
 script_dependencie("phpgroupware_detect.nasl");
 script_require_ports("Services/www", 80);
 script_exclude_keys("Settings/disable_cgi_scanning");
 exit(0);
}

include("http_func.inc");
include("http_keepalive.inc");
include("version_func.inc");

port = get_http_port(default:80);
if(!get_port_state(port))exit(0);

if (!can_host_php(port:port)) exit(0);

if(!version = get_kb_item(string("www/", port, "/phpGroupWare")))exit(0);
if(!matches = eregmatch(string:version, pattern:"^(.+) under (/.*)$"))exit(0);

vers = matches[1];

if(!isnull(vers) && vers >!< "unknown") {

  if(version_is_equal(version: vers, test_version: "0.9.16.12")) {
      security_warning(port:port);
      exit(0);
  }

}

exit(0);
