###############################################################################
# OpenVAS Vulnerability Test
# $Id: phpmyadmin_34253.nasl 6984 2010-03-17 12:20:23Z mime $
#
# phpMyAdmin BLOB Streaming Multiple Input Validation Vulnerabilities
#
# Authors:
# Michael Meyer
#
# Copyright:
# Copyright (c) 2009 Greenbone Networks GmbH
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################


if (description)
{
 script_id(100078);
 script_bugtraq_id(34253);
 script_version ("1.0");

 script_name("phpMyAdmin BLOB Streaming Multiple Input Validation Vulnerabilities");
 desc = "

 Overview:
  
 phpMyAdmin is prone to multiple input-validation vulnerabilities,
 including an HTTP response-splitting vulnerability and a
 local file-include vulnerability.

 These issues can be leveraged to view or execute arbitrary local
 scripts, or misrepresent how web content is served, cached, or
 interpreted. This could aid in various attacks that try to entice
 client users into a false sense of trust. Other attacks are also
 possible.

 Versions prior to phpMyAdmin 3.1.3.1 are vulnerable. 

 Solution:
  Vendor updates are available. Please see http://www.phpmyadmin.net for more
  Information.

 See also:
  http://www.securityfocus.com/bid/34253

 Risk factor : Medium";

 script_description(desc);
 script_summary("Determine if phpMyAdmin is vulnerable to Multiple Input Validation");
 script_category(ACT_GATHER_INFO);
 script_family("Web application abuses");
 script_copyright("This script is Copyright (C) 2009 Greenbone Networks GmbH");
 script_dependencie("secpod_phpmyadmin_detect_900129.nasl");
 script_require_ports("Services/www", 80);
 script_exclude_keys("Settings/disable_cgi_scanning");
 exit(0);
}


 include("http_func.inc");
 include("version_func.inc");
  
 port = get_http_port(default:80);

 if(!get_port_state(port))exit(0);
 if(!can_host_php(port:port))exit(0);

 version = eregmatch(pattern:"(.*) under (/.*)", string:get_kb_item("www/" + port + "/phpMyAdmin"));
 if(isnull(version[1]))exit(0); 

   if (version_is_less(version:version[1], test_version:"3.1.3.1") )    
   { 
        security_warning(port:port);
	exit(0);
   }

exit(0);

