# This script was written by Vlatko Kosturjak <kost@linux.hr>
#
# Distributed under GPL v2+
#
# TODO: 
# - script_oid 
# - report back banners grabbed
# - sign the script
#


if(description)
{
 script_id(80001);
 script_version ("$Revision: 4977 $");
 name = "pnscan (NASL wrapper)";
 script_name(name);
 
 desc = "
This plugin runs pnscan to find open ports.
Pnscan is a lite multi-threaded port scanner.
See the section 'plugins options' to configure it

";

 script_description(desc);
 
 summary = "Performs portscan";
 script_summary(summary);
 
 script_category(ACT_SCANNER);
 
 script_copyright("This script is Copyright (C) 2008 Vlatko Kosturjak");
 family = "Port scanners";
 script_family(family);

 script_add_preference(name:"Pnscan Timeout", type:"entry", value: "");
 script_add_preference(name:"Pnscan Concurrent worker threads", type:"entry", value: "");
 if(defined_func("script_mandatory_keys"))
  script_mandatory_keys("Tools/Present/pnscan");

 exit(0);
}

# script_mandatory_keys compatibility:
include ("toolcheck.inc");
exit_if_not_found (toolname: "pnscan");
# end of script_mandatory_keys compatibility

ip = get_host_ip();
esc_ip = ""; l = strlen(ip);
for (i = 0; i < l; i ++) 
  if (ip[i] == '.')
    esc_ip = strcat(esc_ip, "\.");
  else
    esc_ip = strcat(esc_ip, ip[i]);

prange = get_preference("port_range");
if (! prange) prange = "1-65535"; 
if (prange == "default" )
{
	n = 0;
	str = "";
	while ( port = scanner_get_port(n) )
	{
		if ( n > 0 ) str += "," + string(port);
		else str = string(port);
		n ++;
	}
	prange=str;
}

portrangelist=split(prange,sep:",",keep:FALSE);

n_ports = 0;
oports[0]=0;

foreach pr (portrangelist) {

 i = 0;
 argv[i++] = "pnscan";
 argv[i++] = "-l";

 p = script_get_preference("Pnscan Timeout");
 if ( p) argv[i++] = "-t "+p;

 p = script_get_preference("Pnscan Concurrent worker threads");
 if ( p) argv[i++] = "-n "+p;

 argv[i++] = ip;
 # replace patterns like 1-65535 to 1:65535
 pr2 = ereg_replace (string:pr, pattern:"-",replace:":",icase:FALSE);
 argv[i++] = pr2;

 res = pread(cmd: "pnscan", argv: argv, cd: 1, nice: 5);

# IP_ADDRESS:PORT:TYPE:FULL_BANNER
# 127.0.0.1       :    22 : TXT : SSH-2.0-OpenSSH_4.7p1 Debian-8ubuntu1.2
# 127.0.0.1       :  3306 : HEX : 40 00 00 00 0a 35 2e 30 2e 35 31 61 2d 33 75 62 75 6e 74 75 35 2e 31 00 30 00 00 00 2f 26 6f 21 50 50 22 58 00 2c a2 08 02 00 00 00 00 00 00 00 00 00 00 00 00 00 00 72 56 39 5a 39 4b 50 2d 32

	foreach line(split(res))
	{
	  v = eregmatch(string: line, pattern: '^'+esc_ip+' *: *([0-9]+) *:([^:]*): *(.*)$');
	  if (! isnull(v))
	  {
		port = v[1];
		if (isnull(oports[port])) {
			n_ports++;
			oports[port]=port;
			proto = "tcp";
		   scanner_add_port(proto: proto, port: port);
		}
	  }
	}

}

if (n_ports == 0) {
	security_note(port:0,proto:"tcp",data:"Host does not have any TCP port open which is specified in port range");
}

set_kb_item(name: "Host/scanned", value: TRUE);
set_kb_item(name: 'Host/scanners/pnscan', value: TRUE);
if (pr2 == '1:65535')
  set_kb_item(name: "Host/full_scan", value: TRUE);

scanner_status(current: 65535, total: 65535);

exit (0);
