###############################################################################
# OpenVAS Vulnerability Test
# $Id: postgresql_detect.nasl 6984 2010-03-17 12:20:23Z mime $
#
# Detection of PostgreSQL
#
# Authors:
# Michael Meyer
#
# Copyright:
# Copyright (c) 2009 Greenbone Networks GmbH
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

desc = "

 Overview:
  PostgreSQL, a open source object-relational database system is running at
  this host.

 See also:
  http://www.postgresql.org  

 Risk factor : None";

if (description)
{
 script_id(100151);
 script_version ("1.0");

 script_name("PostgreSQL Detection");  

 script_description(desc);
 script_summary("Check for PostgreSQL");
 script_category(ACT_GATHER_INFO);
 script_family("Service detection");
 script_copyright("This script is Copyright (C) 2009 Greenbone Networks GmbH");
 script_dependencie("find_service.nes");
 script_require_ports("Services/postgresql", 5432);
 exit(0);
}

include("global_settings.inc");
include("misc_func.inc");
include("dump.inc");

function bin2string (ddata) {
 local_var tmp, i, j, line, linenumber, len, data, c;

 len = strlen (ddata);
 linenumber = len / 16;

 for (i = 0; i <= linenumber; i++)
 {
  line = line2string (line:i, linenumber:len);
  data = "";

  for (j = 0; j < 16; j++)
  {
   if ( (i*16+j) < len )
   {
    c = ddata[i*16+j];

    if (isprint (c:c))
      data += c;
   }
  }

  tmp += string (data);
 }

 return tmp;
}

port = 5432;
if(!get_tcp_port_state(port))exit(0);

soc = open_sock_tcp(port);
if(!soc)exit(0);

#user: postgres, database: postgres,client_encoding: unicode,
#datestyle: iso
req = raw_string(0x00,0x00,0x00,0x4f,0x00,0x03,0x00,0x00,0x75,0x73,0x65,0x72,0x00,0x70,0x6f,0x73,
		 0x74,0x67,0x72,0x65,0x73,0x00,0x64,0x61,0x74,0x61,0x62,0x61,0x73,0x65,0x00,0x70,
		 0x6f,0x73,0x74,0x67,0x72,0x65,0x73,0x00,0x63,0x6c,0x69,0x65,0x6e,0x74,0x5f,0x65,
		 0x6e,0x63,0x6f,0x64,0x69,0x6e,0x67,0x00,0x55,0x4e,0x49,0x43,0x4f,0x44,0x45,0x00,
		 0x44,0x61,0x74,0x65,0x53,0x74,0x79,0x6c,0x65,0x00,0x49,0x53,0x4f,0x00,0x00);

send(socket:soc, data:req);
res = recv(socket:soc, length:256);

if (!res || res[0] >!< "(E|R)" )exit(0);

dump = bin2string(ddata:res);

b = substr(res, 1, 4);
blen = ord(b[0])/24 | ord(b[1])/16 | ord(b[2])/8 | ord(b[3]);

if ((dump[0] == "E")  &&
    (
    "ERROR"   >< dump ||
    "FATAL"   >< dump ||
    "PANIC"   >< dump ||
    "WARNING" >< dump ||
    "NOTICE"  >< dump ||
    "DEBUG"   >< dump ||
    "INFO"    >< dump ||
    "LOG"     >< dump
    ) ||
    dump[0] == "R" && (blen == 8 || blen == 12) )
{

  txt = desc;

  if(dump[0] == "R") {

   version = eregmatch(pattern:"server_version([0-9.]+)", string: dump);
   if(!isnull(version[1])) {
    vers = version[1];
    set_kb_item(name:"PostgreSQL/Remote/" + port + "/Ver", value: vers);
    info = string("None\n\nPostgreSQL Version '");
    info += vers;
    info += string("' was detected on the remote host.\n\n");

    txt = ereg_replace(
    	string:desc,
    	pattern:"None$",
    	replace:info
    ); 

   }  
  }  

  register_service(port:port, proto:"postgresql");
  if(report_verbosity > 0) { 
    security_note(port:port, data:txt);
  }
  exit(0);
}

exit(0);
