###############################################################################
# OpenVAS Vulnerability Test
# $Id$
#
# PRTG Traffic Grapher Detection
#
# Authors:
# Michael Meyer
#
# Copyright:
# Copyright (c) 2009 Greenbone Networks GmbH
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

# need desc here to modify it later in script.
desc = "

 Overview:
  PRTG Traffic Grapher, a Windows software for monitoring and
  classifying bandwidth traffic usage is running at this host.

 See also:
  http://www.paessler.com/prtg6

 Risk factor : None";

if (description)
{
 script_id(100215);
 script_version ("1.0");

 script_name("PRTG Traffic Grapher Detection");  

 script_description(desc);
 script_summary("Checks for the presence of PRTG Traffic Grapher");
 script_category(ACT_GATHER_INFO);
 script_family("Service detection");
 script_copyright("This script is Copyright (C) 2009 Greenbone Networks GmbH");
 script_dependencie("find_service.nes", "http_version.nasl");
 script_require_ports("Services/www", 80);
 script_exclude_keys("Settings/disable_cgi_scanning");
 exit(0);
}

include("http_func.inc");
include("http_keepalive.inc");
include("global_settings.inc");

port = get_http_port(default:80);

if(!get_port_state(port))exit(0);

 url = string("/login.htm"); 
 req = http_get(item:url, port:port);
 buf = http_keepalive_send_recv(port:port, data:req, bodyonly:FALSE);  

 if( buf == NULL )continue;
 if( egrep(pattern: 'PRTG Traffic Grapher V[0-9.]+', string: buf, icase: TRUE) &&
     egrep(pattern: 'sensorlist.htm', string: buf, icase: TRUE) )
 { 
   
    vers = string("unknown");

    ### try to get version.
    version = eregmatch(string: buf, pattern: 'PRTG Traffic Grapher V([0-9.]+)',icase:TRUE);
    
    if ( !isnull(version[1]) ) {
       vers=version[1];
    } 

    set_kb_item(name: string("www/", port, "/PRTGTrafficGrapher"), value: string(vers," under /"));

    info = string("None\n\nPRTG Traffic Grapher Version '");
    info += string(vers);
    info += string("' was detected on the remote host\n");

    desc = ereg_replace(
        string:desc,
        pattern:"None$",
        replace:info
    );    
       
       if(report_verbosity > 0) {
         security_note(port:port,data:desc);
       }
       exit(0);
  
 }

exit(0);
