########################################################################################
#  This script was written by David Maciejak <david dot maciejak at kyxar dot fr>
#  based on work from
#  (C) Tenable Network Security
#
# This script is released under the GNU GPLv2
#
#
#########################################################################################
if(description)
{
  script_id(14262);
  script_cve_id("CVE-2003-0069");
  script_version("$Revision: 4334 $");
  script_name("PuTTY window title escape character arbitrary command execution");
  desc = "
  PuTTY is a free SSH client.
  This version contains a flaw that may allow a malicious user to insert
  arbitrary commands and execute them.
  The issue is triggered when an attacker sends commands,
  preceded by terminal emulator escape sequences.
  It is possible that the flaw may allow arbitrary code execution
  resulting in a loss of integrity.

  Solution : Upgrade to version 0.54 or newer
  Risk factor : High";

  script_description(desc);
  script_summary("Determine PuTTY version");
  script_category(ACT_GATHER_INFO);
  script_copyright("This script is Copyright (C) 2004 David Maciejak");
  script_family("Windows");
  script_dependencies("secpod_putty_version.nasl","secpod_reg_enum.nasl");
  script_require_keys("SMB/PuTTY/version");
  script_require_ports(139, 445); 
  exit(0);
}

include("smb_nt.inc");
include("version_func.inc");
include("secpod_smb_func.inc");

puttyVer=get_kb_item("PuTTY/Version");
if(!puttyVer){
  exit(0);
}

if(version_is_less_equal(version:puttyVer, test_version:"0.53")){
  security_hole(0);
}

